<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\admin\controller\users;

use app\admin\controller\AdminBase;
use app\admin\validate\MailValidate;
use think\App;
use think\facade\Db;
use app\model\project\Mail as MailModel;

/**
 * 后台主控制器
 */
class Mail extends AdminBase
{

    protected $mail;

    public function __construct(App $app)
    {
        parent::__construct($app);

        $this->mail = new MailModel();

    }

    // 列表
    public function index(string $do = '')
    {

        $limit = 10;
        if ($do == 'json') {

            $post = input();
            $post['limit'] = isset($post['limit']) ? $post['limit'] : $limit;
            $map = [];
            $hasmap = [];
            if (isset($post['kw']) && !empty($post['kw'])) {
                $map[] = ['content', 'like', '%' . $post['kw'] . '%'];
            }
            if (isset($post['user']) && !empty($post['user'])) {
                $hasmap[] = ['username|mobile', 'like', '%' . $post['user'] . '%'];
            }

            $list = $this->mail->where($map)->hasWhere('getuserdata', $hasmap)->with(['getuserdata'])->append(['type_text'])->order('createtime desc')->paginate($post['limit']);
            return $this->returnMsg($list);
        }

        $this->assign('limit', $limit);
        return $this->fetch('', '', false);
    }

    //新增
    public function add()
    {
        $post = input();
        if ($this->request->isPost()) {

            $check = (new MailValidate())->goCheck();
            if ($check !== true) {
                return $check;
            }
            try {
                $map[] = ['is_del', '=', '0'];
                if ($post['user']) {
                    $map[] = ['id|mobile', 'in', $post['user']];
                }
                $stime = time();
                $maildata = Db::name('user')->field('id')->where($map)->select()->each(function ($item, $key) use ($post, $stime) {

                    return ['content' => $post['content'], 'type' => 1, 'user_id' => $item['id'], 'createtime' => $stime];
                });
                $this->mail->saveAll($maildata);

            } catch (\Exception $e) {

                return $this->returnMsg($e->getMessage(), 0);
            }
            return $this->returnMsg('发送成功', 1);

        }
        return $this->fetch('', '', false);
    }

    //快速编辑
    public function editup()
    {

        $post = input();
        $result = $this->mail->update([$post['af'] => $post['av']], [['id', '=', $post['id']]]);
        if ($result) {
            return $this->returnMsg('修改成功', 1);
        } else {
            return $this->returnMsg('修改失败');
        }
    }

    public function del()
    {
        $post = input();
//        $ids = is_array($post['id']) ? implode(',', $post['id']) : $post['id'];
        if ($this->mail->destroy($post['id'])) {
            return $this->returnMsg("删除成功", 1);
        } else {
            return $this->returnMsg("删除失败");
        }
    }


}