<?php

namespace app\api\controller\manage;

use app\api\middleware\Auth;
use app\api\service\UtilService;
use app\api\validate\BusinessValidate;
use app\BaseController;
use app\model\Payment;
use app\model\project\School;
use app\model\project\UserMoneyLog;
use app\model\project\UserWithdrawal;
use app\Request;
use think\facade\Db;
use app\model\project\User as UserModel;
use app\model\project\Business;

class User extends BaseController
{

    protected $middleware = [
        Auth::class,
    ];


    //获取企业信息
    public function getBusinessInfo(Request $request)
    {

        $info = Business::where(['user_id' => $request->userId, 'is_del' => '0'])
            ->with(['businessQualification', 'businessfrsfzqian', 'businessfrsfzhou'])
            ->append(['provice_city'])
            ->find();
        return $this->returnMsg('操作成功', 1, $info);

    }

    //获取学校信息
    public function getSchoolInfo(Request $request)
    {

        $info = School::where(['user_id' => $request->userId, 'is_del' => '0'])
            ->with(['schoolQualification', 'schoolfrsfzqian', 'schoolfrsfzhou'])
            ->append(['provice_city'])
            ->find();
        return $this->returnMsg('操作成功', 1, $info);

    }

    //修改企业信息
    public function editBusinessInfo(Request $request)
    {
        $filed = ['frxm', 'qydm', 'frsfz', 'business_qualification_url_id','frsfz_qian','frsfz_hou','contacts_name','contacts_phone','contacts_email'];
//        $vo = (new BusinessValidate())->goCheck(['frxm', 'qydm', 'frsfz', 'business_qualification_url_id']);
//        if ($vo !== true) {
//            return $vo;
//        }
        $updatedata = $request->only($filed);
        $result = Business::where(['user_id' => $request->userId, 'is_del' => '0'])->update($updatedata);
        return $this->returnMsg('操作成功', 1, $result);

    }

    //修改学校信息
    public function editSchoolInfo(Request $request)
    {
        $filed = ['frxm', 'qydm', 'frsfz', 'school_qualification_url_id','frsfz_qian','frsfz_hou','contacts_name','contacts_phone','contacts_email'];
//        $vo = (new BusinessValidate())->goCheck(['frxm', 'qydm', 'frsfz', 'business_qualification_url_id']);
//        if ($vo !== true) {
//            return $vo;
//        }
        $updatedata = $request->only($filed);
        $result = School::where(['user_id' => $request->userId, 'is_del' => '0'])->update($updatedata);
        return $this->returnMsg('操作成功', 1, $result);

    }


    //用户订单
    public function getOrderList(Request $request)
    {
        $page = $request->param('page/d', 1);
        $pageSize = $request->param('pageSize/d', 10);

        $where = ['store_user_id' => $request->userId];

        // 搜索条件
        $order_no = $request->param('order_no', '');
        if ($order_no) {
            $where['order_no'] = ['like', "%{$order_no}%"];
        }

        $pay_no = $request->param('pay_no', '');
        if ($pay_no) {
            $where['pay_no'] = ['like', "%{$pay_no}%"];
        }

        $keyword = $request->param('keyword', '');
        if ($keyword) {
            $where['subject'] = ['like', "%{$keyword}%"];
        }

        $query = Payment::where($where)
//            ->leftJoin('course c', "p.order_id = c.id AND p.order_type = 1")
//            ->leftJoin('cert ce', "p.order_id = ce.id AND p.order_type = 2")
            ->field([
                'order_no',
                'pay_no',
                'user_id',
                'store_user_id',
                'createtime',
                'pay_channel',
                'pay_method',
                'order_price',
                'pay_amount',
                'pay_status',
                'order_type',
                'pay_time',
                'subject'
            ])
         ->with(['getuserdata'])
        ->append(['pay_method_text','pay_status_text','pay_time_text']);



        $list = $query->order('createtime', 'desc')
            ->paginate([
                'page' => $page,
                'list_rows' => $pageSize
            ]);

        // foreach ($list as &$item) {
        //     $item['order_type_text'] = $item['order_type'] == 1 ? '课程' : '证书';
        //     $item['pay_method_text'] = $item['pay_method'] == 1 ? '支付宝' : '微信';
        // }
        // unset($item);

        return $this->returnMsg('success', 1, $list);
    }

    /**提现列表
     * @param Request $request
     * @return \app\html
     */

    public function withdrawList(Request $request)
    {
        $field = ['page','pageSize','sn','sh_status','dk_status','start_time','end_time'];

        $params = $request->only($field);
        $params['userId'] = $request->userId;

        $userWithDrawModel =new UserWithdrawal();

        $list = $userWithDrawModel->getWithdrawalList($params);

        return $this->returnMsg('success', 1, $list);

    }

    /**账变列表
     * @param Request $request
     * @return \app\html
     */

    public function moneyLog(Request $request)
    {
        $field = ['page','pageSize','type','money_type','sz_type','start_time','end_time'];

        $params = $request->only($field);
        $params['userId'] = $request->userId;

        $userMoneyLog = new UserMoneyLog();

        $list = $userMoneyLog->moneyLogList($params);

        return $this->returnMsg('success', 1, $list);
    }

}