<?php

namespace app\api\controller;

use app\BaseController;
use app\model\project\AdvertCate;

class System extends BaseController
{

    /**
     * 轮播图列表
     */
    public function getBannerList()
    {

        $position = $this->request->param('position', '0');
        $list = AdvertCate::where(['id' => $position, 'is_show' => 1, 'is_del' => 0])
            ->with(['getAdvertList' => ['coverImg']])
            ->find();
        return $this->returnMsg('操作成功', 1, $list);

    }

    //热搜榜
    public function gethotlist()
    {
        $hotlist = explode("\n", vconfig('hot_keywork', []));
        $newhotlist = [];
        foreach ($hotlist as &$item) {
            $arr = explode('|', $item);
            $newhotlist[] = array(
                'title' => $arr[0],
                'tag' => isset($arr[1]) ? $arr[1] : '',
            );

        }
        return $this->returnMsg('操作成功', 1, $newhotlist);
    }

}