<?php

namespace app\api\controller\project;

use app\api\service\UserService;
use app\api\validate\ProjectValidate;
use app\BaseController;
use app\model\project\UserMoneyLog;
use app\model\ProjectTag;
use think\Request;
use app\model\ProjectCategory;
use app\model\Project as ProjectModel;

class Project extends BaseController
{
    //项目分类列表
    public function getProjectCategoryList()
    {
        $list = (new ProjectCategory())->getProjectCategoryList();

        return $this->returnMsg('success',1,$list);
    }

    //项目子分类列表
    public function getProjectCategoryChildrenList(Request $request)
    {
        $vo = (new ProjectValidate())->goCheck(['pid']);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->param();

        $list = (new ProjectCategory())->getProjectCategoryList($data['pid']);

        return $this->returnMsg('success',1,$list);
    }

    //项目列表
    public function getProjectList(Request $request)
    {
        $vo = (new ProjectValidate())->goCheck(['category_id','type']);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->param();

        $page = $request->param('page/d', 1);
        $pageSize = $request->param('pageSize/d', 10);

        $list = (new ProjectModel())->getProjectList($data['category_id'],$page,$pageSize,$data['type']);

        return $this->returnMsg('success',1,$list);
    }

    public function rankProjectList(Request $request)
    {

        $limit = $request->param('limit/d', 1);
        $type = $request->param('type', 'day');


        $list = UserMoneyLog::getUserMoneyRanking($limit,$type,0);

        return $this->returnMsg('success',1,$list);

    }

    public function getProjectDetail(Request $request)
    {

        $vo = (new ProjectValidate())->goCheck(['project_id']);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->param();
        $userId = 0;

        $token = $request->header('token');
        if ($token)
        {
            $userId = UserService::getUserInfo($token)['id'] ?? 0;
        }


        $detail = (new ProjectModel())->projectDetail($data['project_id'],$userId);

        return $this->returnMsg('success',1,$detail);

    }

    /**热门标签
     * @param Request $request
     * @return \app\html
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function getProjectHotTags(Request $request)
    {
        // 获取所有有效项目的标签ID
        $projects = ProjectModel::where('sh_status', 2)  // 只统计审核通过的项目
            ->where('status', '<>', 5)   // 排除已取消的项目
            ->column('tag_ids');
        
        // 统计标签使用频率
        $tagCount = [];
        foreach ($projects as $tagIds) {
            if (empty($tagIds)) {
                continue;
            }
            $tagIdArray = explode(',', $tagIds);
            foreach ($tagIdArray as $tagId) {
                if (!isset($tagCount[$tagId])) {
                    $tagCount[$tagId] = 0;
                }
                $tagCount[$tagId]++;
            }
        }
        
        // 如果没有标签数据
        if (empty($tagCount)) {
            return $this->returnMsg('success', 1, []);
        }
        
        // 获取标签详细信息
        $tagIds = array_keys($tagCount);
        $tags = ProjectTag::where('id', 'in', $tagIds)
            ->where('is_del', 0)
            ->field(['id', 'title'])
            ->select()
            ->toArray();
            
        // 组装最终数据，包含使用次数
        foreach ($tags as &$tag) {
            $tag['count'] = $tagCount[$tag['id']];
        }
        
        // 按使用次数降序排序
        usort($tags, function($a, $b) {
            return $b['count'] - $a['count'];
        });
        
        return $this->returnMsg('success', 1, $tags);
    }



}