<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace veitool\storage\engine;

use OSS\OssClient;
use OSS\Core\OssException;

/**
 * 阿里云存储引擎 (OSS)
 * Class Qiniu
 * @package app\common\library\storage\engine
 */
class Aliyun extends Server
{
//    private $config;

    /**
     * 构造方法
     * Aliyun constructor.
     * @param $config
     */
    public function __construct($config)
    {
        parent::__construct($config);
//        $this->config = $config;
    }

    /**
     * 执行上传
     * @return bool|mixed
     */
    public function upload()
    {
        $type = $this->config['type'];
        $type = isset($this->config[$type]) && is_array($this->config[$type]) ? $type : 'image';
        $ext  = $this->config[$type]['ext'];
        $size = $this->config[$type]['size'];

        try{
            validate(['file'=>[
                'fileSize' => $size * 1024 * 1024,
                'fileExt'  => $ext
            ]],[
                'file.fileSize' => '上传的文件大小不能超过'.$size.'M',
                'file.fileExt'  => '请上传后缀为:'.$ext.'的文件'
            ])->check(['file'=> $this->file]);
        }catch(\think\exception\ValidateException $e){
            $this->error = $e->getError();
            return false;
        }


        try {
            $ossClient = new OssClient(
                $this->config['access_key_id'],
                $this->config['access_key_secret'],
                $this->config['domain'],
                true
            );

            $result = $ossClient->uploadFile(
                $this->config['bucket'],
                $this->fileName,
                $this->file->getRealPath()
            );
        } catch (OssException $e) {
            $this->error = $e->getMessage();
            return false;
        }
        return true;
    }

    /**
     * 删除文件
     * @param $fileName
     * @return bool|mixed
     */
    public function delete($fileName)
    {
        try {
            $ossClient = new OssClient(
                $this->config['access_key_id'],
                $this->config['access_key_secret'],
                $this->config['domain'],
                true
            );
            $ossClient->deleteObject($this->config['bucket'], $fileName);
        } catch (OssException $e) {
            $this->error = $e->getMessage();
            return false;
        }
        return true;
    }

    /**
     * 返回文件路径
     * @return mixed
     */
    public function getFileName()
    {
        return $this->fileName;
    }

}