<?php

namespace app\model\project;

use app\model\system\SystemUploadFile;
use think\Model;

class School extends Model
{
    protected $name = 'school';

    protected $autoWriteTimestamp = true;

    protected $createTime = 'create_time';

    //学校资质id
    public function schoolQualification()
    {
        return $this->hasOne(SystemUploadFile::class, 'fileid', 'school_qualification_url_id')
            ->where('isdel', 0)
            ->field('fileid,filename,filesize,fileurl,filetype,fileext');
    }

    //导师资质
    public function teacherQualification()
    {
        return $this->hasOne(SystemUploadFile::class, 'fileid', 'teacher_qualification_url_id')
            ->where('isdel', 0)
            ->field('fileid, filename, filesize, fileurl, filetype,fileext');
    }

    //合作协议
    public function agreement()
    {
        return $this->hasOne(SystemUploadFile::class, 'fileid', 'agreement_url_id')
            ->where('isdel', 0)
            ->field('fileid, filename, filesize, fileurl, filetype,fileext');
    }

    //补充材料
    public function moreFile()
    {
        return $this->hasOne(SystemUploadFile::class, 'fileid', 'more_url_id')
            ->where('isdel', 0)
            ->field('fileid, filename, filesize, fileurl, filetype,fileext');
    }

    //用户信息
    public function getuserdata()
    {
        return $this->belongsTo(User::class, 'user_id')
            ->field('username,mobile,id');
    }

    //详细地址
    public function getAddressxxAttr($value, $data)
    {
        return $data['province'].'-'.$data['city'].'-'.$data['area'];
    }

    public function getStatusTextAttr($value, $data)
    {
        switch ($data['status']) {
            case 1:
                $statustxt = '审核成功';
                break;
            case 2:
                $statustxt = '审核失败';
                break;
            default:
                $statustxt = '待审核';
        }

        return $statustxt;
    }

}