<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\model;

use think\facade\Db;
use think\Model;
use think\model\concern\SoftDelete;

/**
 * 模型公用类
 */
class Student extends Model
{

    protected $autoWriteTimestamp = true;
    protected $createTime = 'createtime';
    use SoftDelete;

    protected $deleteTime = 'deletetime';

    public function userprofile()
    {
        return $this->belongsTo(\app\model\project\User::class, 'user_id')
            ->field('id,mobile,username');
    }

    public function getBirthdayTextAttr($value, $data)
    {
        return date('Y-m-d', $data['birthday']);
    }

    public function getSexTextAttr($value, $data)
    {
        switch ($data['sex']) {

            case 1:
                $text = '男';
                break;
            case 2:
                $text = '女';
                break;
            default:
                $text = '未知';
                break;
        }

        return $text;
    }

    public static function excelfiled($thisitem, $k, $datalin)
    {

        if ($thisitem == '姓名') {
            $datalin['realname'] = $k;
        } elseif ($thisitem == '联系方式') {
            $datalin['mobile'] = $k;
        } elseif ($thisitem == '性别') {
            $datalin['sex'] = $k;
        } elseif ($thisitem == '年龄') {
            $datalin['age'] = $k;
        } elseif ($thisitem == '证件号码') {
            $datalin['idcard'] = $k;
        } elseif ($thisitem == '出生年月') {
            $datalin['birthday'] = $k;
        } elseif ($thisitem == '校区') {
            $datalin['xq'] = $k;
        } elseif ($thisitem == '年纪') {
            $datalin['nj'] = $k;
        } elseif ($thisitem == '班级') {
            $datalin['bj'] = $k;
        } elseif ($thisitem == '学号') {
            $datalin['xh'] = $k;
        }

        return $datalin;
    }

    public function setSexAttr($value, $data)
    {
        $text = $value;
        switch ($data['sex']) {

            case '男':
                $text = 1;
                break;
            case '女':
                $text = 2;
                break;
            case '未知':
                $text = 0;
                break;
        }

        return $text;
    }
}