<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2020-2022 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */
namespace addons\vtool;

use veitool\addons\Base;

use tool\Menus;
use think\facade\Db;

/**
 * Vtool插件
 */
class Vtool extends Base
{
    /**
     * 插件名称
     * @var string
     */
    private $name = 'vtool';

    /**
     * 插件安装方法 必须要实现的
     * @return bool
     */
    public function install()
    {
        //引入菜单数据并导入
        $file = str_replace('\\', '/', dirname(__FILE__)) . '/data/menus.php';
        if(is_file($file)){
            $data = include_once $file;
            Menus::create($data,1,$this->name);
        }

        //追加插件应用路由
        $this->setAddons([$this->name]);

        return true;
    }

    /**
     * 插件卸载方法 必须要实现的
     * @return bool
     */
    public function uninstall()
    {
        //删除相关菜单项
        Menus::delete($this->name);

        /* 删除安装的相关数据表  【如果表名中含有 "pre_插件标识符_" 的前缀 则不需要这一步】 */
        if(config('veitool.ddata',1)){
            $prefix = config('database.connections.'.config('database.default').'.prefix');
            Db::execute("DROP TABLE IF EXISTS `{$prefix}build_module`");
        }/**/

        //剔除系统应用路由
        $this->setAddons([$this->name], false);

        return true;
    }

    /**
     * 插件升级方法、变动的数据、配置处理逻辑
     * @return bool
     */
    public function upgrade()
    {
        $pre = config('database.connections.'.config('database.default').'.prefix');
        Db::query("ALTER TABLE {$pre}build_module ADD COLUMN `state` tinyint(1) unsigned NOT NULL DEFAULT 1 COMMENT '状态：0停用1启用' AFTER note;");
        return true;
    }

    /**
     * 插件启用方法
     * @return bool
     */
    public function enable()
    {
        Menus::enable($this->name);
        //追加插件应用路由
        $this->setAddons([$this->name]);
        return true;
    }

    /**
     * 插件禁用方法
     * @return bool
     */
    public function disable()
    {
        Menus::disable($this->name);
        //剔除系统应用路由
        $this->setAddons([$this->name], false);
        return true;
    }

}
