<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\admin\controller\cert;

use app\admin\controller\AdminBase;
use app\model\CertOrder as CertOrderModel;
use think\App;
/**
 * 后台主控制器
 */
class CertOrder extends AdminBase
{

    protected $certorder;

    public function __construct(App $app)
    {
        parent::__construct($app);

        $this->certorder = new CertOrderModel();

    }

    // 列表
    public function index(string $do = '')
    {

        $limit = 10;
        if ($do == 'json') {

            $post = input();
            $post['limit'] = isset($post['limit']) ? $post['limit'] : $limit;
            $map[] = ['is_del', '=', 0];
            $map[] = ['status', '>', 0];

            if (isset($post['kw']) && !empty($post['kw'])) {
                $map[] = ['title', 'like', '%' . $post['kw'] . '%'];
            }
            if (isset($post['cate_id']) && !empty($post['cate_id'])) {
                $map[] = ['cate_id', '=', $post['cate_id']];
            }
            $list = $this->certorder->where($map)->with(['certdata','userprofile'])->order('createtime desc')->paginate($post['limit']);
            return $this->returnMsg($list);
        }

        $this->assign('limit', $limit);
        return $this->fetch('', '', false);
    }

    //快速编辑
    public function editup()
    {

        $post = input();
        $result = $this->certorder->update([$post['af'] => $post['av']], [['id', '=', $post['id']]]);
        if($result){
            return $this->returnMsg('修改成功',1);
        }else{
            return $this->returnMsg('修改成功');
        }
    }

    public function del()
    {
        $post = input();
        $ids = is_array($post['id']) ? implode(',', $post['id']) : $post['id'];
        if ($this->certorder->where("id IN(" . $ids . ")")->update(['is_del' => 1])) {
            $cert_id_arr = $this->certorder->where("id IN(" . $ids . ")")->column('id');
            $cert_id_arr = array_unique($cert_id_arr);
            foreach ($cert_id_arr as $cert_id) {
                event('cert', ['cert_id' => $cert_id, 'tasktype' => 'cert', 'action' => 'shcertupdate']);
            }

            return $this->returnMsg("删除成功", 1);
        } else {
            return $this->returnMsg("删除失败");
        }
    }





    //详情
    public function detail()
    {
        $post = input();
        $info = $this->certorder->where('id', $post['id'])->find();
        $this->assign('info', $info);
        return $this->fetch('', '', false);
    }

}