<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\model;
use app\model\project\User;
use think\Model;

/**
 * 课程模型
 */
class CertOrder extends Model
{

    public function certdata()
    {
        return $this->hasOne(Cert::class, 'id', 'cert_id')
            ->field('id,title,price');

    }

    public function userprofile()
    {
        return $this->belongsTo(User::class, 'user_id', 'id')
            ->field('id,username,mobile');
    }

    public function getOtherFileListAttr($value, $data)
    {
        return get_upload_file($data['other_file_id'],'list');
    }
    public function getCreatetimeAttr($value)
    {
        return date('Y-m-d H:i:s', $value);
    }
    public function getStatusTextAttr($value, $data)
    {
        switch ($data['status']) {
            case 2:
                $statustxt = '申请失败';
                break;
            case 3:
                $statustxt = '申请成功';
                break;
            default:
                $statustxt = '申请中';
        }
        return $statustxt;
    }

}