<?php

namespace app\api\middleware;
use app\api\service\TokenService;
use app\BaseController;
use think\facade\Request;
use think\Response;

class Auth extends BaseController
{
    public function handle($request, \Closure $next)
    {
        // 在这里编写你的验证逻辑
        $token = $request->header('token');

        if (!$this->checkToken($token)) {
            return $this->returnMsg('Unauthorized',201);
        }

        return $next($request);
    }

    protected function checkToken($token)
    {
        // 实现你的token验证逻辑
        // 返回true或false

        if (!$token)
        {
            return false;

        }

        $user = TokenService::verifyToken($token);
        if ($user===false)
        {
            return false;
        }

        return true;
    }
}