<?php

namespace app\model\project;

use app\model\system\SystemUploadFile;
use think\Model;

class Business extends Model
{
    protected $name = 'business';

    protected $autoWriteTimestamp = true;

    protected $createTime = 'create_time';

    // 营业执照文件列表（原 businessQualification）
    public function getBusinessQualificationListAttr()
    {
        if (empty($this->business_qualification_url_id)) {
            return [];
        }
        return get_upload_file($this->business_qualification_url_id, 'list');
    }

// 行业文件列表（原 businessIndustry）
    public function getBusinessIndustryListAttr()
    {
        if (empty($this->business_industry_url_id)) {
            return [];
        }
        return get_upload_file($this->business_industry_url_id, 'list');
    }

// 项目文件列表（原 businessPorject）
    public function getBusinessProjectListAttr()
    {
        if (empty($this->business_project_url_id)) {
            return [];
        }
        return get_upload_file($this->business_project_url_id, 'list');
    }

// 补充材料文件列表（原 businessMore）
    public function getBusinessMoreListAttr()
    {
        if (empty($this->more_url_id)) {
            return [];
        }
        return get_upload_file($this->more_url_id, 'list');
    }

    // 营业执照文件关联
    public function businessQualification()
    {
        return $this->hasOne(SystemUploadFile::class, 'fileid', 'business_qualification_url_id')
            ->where('isdel', 0)
            ->field('fileid,filename,filesize,fileurl,filetype,fileext,storage');
    }

    //行业
    public function businessIndustry()
    {
        return $this->hasOne(SystemUploadFile::class, 'fileid', 'business_industry_url_id')
            ->where('isdel', 0)
            ->field('fileid,filename,filesize,fileurl,filetype,fileext,storage');
    }

    //项目
    public function businessPorject()
    {
        return $this->hasOne(SystemUploadFile::class, 'fileid', 'business_project_url_id')
            ->where('isdel', 0)
            ->field('fileid,filename,filesize,fileurl,filetype,fileext,storage');
    }

    //补充材料
    public function businessMore()
    {
        return $this->hasOne(SystemUploadFile::class, 'fileid', 'more_url_id')
            ->where('isdel', 0)
            ->field('fileid,filename,filesize,fileurl,filetype,fileext,storage');
    }

    //企业logo
    public function businessLogo()
    {
        return $this->hasOne(SystemUploadFile::class, 'fileid', 'business_logo_url_id')
            ->where('isdel', 0)
            ->field('fileid,filename,filesize,fileurl,filetype,fileext,storage');
    }


    //法人身份证正面
    public function businessfrsfzqian()
    {
        return $this->hasOne(SystemUploadFile::class, 'fileid', 'frsfz_qian')
            ->where('isdel', 0)
            ->field('fileid,filename,filesize,fileurl,filetype,fileext,storage');
    }

    //法人身份证反面
    public function businessfrsfzhou()
    {
        return $this->hasOne(SystemUploadFile::class, 'fileid', 'frsfz_hou')
            ->where('isdel', 0)
            ->field('fileid,filename,filesize,fileurl,filetype,fileext,storage');

    }

    //用户信息
    public function getuserdata()
    {
        return $this->belongsTo(User::class, 'user_id')
            ->field('username,mobile,id');
    }

    //详细地址
    public function getAddressxxAttr($value, $data)
    {
        return $data['province'].'-'.$data['city'].'-'.$data['area'];
    }

    //所在地区
    public function getProviceCityAttr($value, $data)
    {
        return  get_area_name($data['province']).'-'.get_area_name($data['city']);
    }

    public function getStatusTextAttr($value, $data)
    {
        switch ($data['status']) {
            case 1:
                $statustxt = '审核成功';
                break;
            case 2:
                $statustxt = '审核失败';
                break;
            default:
                $statustxt = '待审核';
        }

        return $statustxt;
    }
}