<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\model;

use app\api\service\UtilService;
use app\model\project\User;
use app\model\system\SystemUploadFile;
use think\facade\Db;
use think\Model;
use think\model\concern\SoftDelete;

/**
 * 课程模型
 */
class StudyInformation extends Model
{

    use SoftDelete;
    protected $deleteTime = 'deletetime';
    protected $autoWriteTimestamp = true;
    protected $createTime = 'createtime';
    protected $updateTime = 'updatetime';


    public function getStatusTextAttr($value, $data)
    {
        switch ($data['status']) {

            case 1:
                $statustxt = '审核失败';
                break;
            case 2:
                $statustxt = '审核成功';
                break;
            default:
                $statustxt = '待审核';
        }

        return $statustxt;
    }

    public function getTypeTextAttr($value, $data)
    {
        switch ($data['type']) {

            case 'content':
                $statustxt = '文本';
                break;
            default:
                $statustxt = $data['type'];
        }

        return $statustxt;
    }

    public function studycatedata()
    {

        return $this->hasOne(StudyCategory::class, 'id', 'cate_id')
            ->field('id,title');

    }

    //用户信息
    public function getuserdata()
    {
        return $this->belongsTo(User::class, 'user_id')
            ->field('username,mobile,id');
    }

    //附件
    public function filepath()
    {
        return $this->hasOne(SystemUploadFile::class, 'fileid', 'file_id')
            ->where('isdel',0);
    }

}