<?php

namespace app\api\controller;

use app\BaseController;
use think\facade\Cache;
use think\facade\Db;

class Search extends BaseController
{
    public function searchPlus()
    {
        $keyword = $this->request->param('searchKeyWords', '');
        $page = $this->request->param('page/d', 1);
        $pageSize = $this->request->param('pageSize/d', 10);

        $cacheKey = 'search_plus_' . md5($keyword . '_' . $page . '_' . $pageSize);

        $cacheData = Cache::get($cacheKey);
        if ($cacheData !== null) {
            return $this->returnMsg('success', 1, $cacheData);
        }

        $currentTime = time();

        // 构建UNION ALL查询
        $baseQuery = '(SELECT a.id, a.title, a.description, IFNULL(b.fileurl, "") as thumb, a.createtime, c.nickname as username, "kc" AS source 
                      FROM fj_course a 
                      LEFT JOIN fj_system_upload_file b ON a.thumb = b.fileid 
                      LEFT JOIN fj_course_teacher c ON a.teacher_id = c.id
                      WHERE a.is_sell = 1 AND a.is_del = 0 AND a.status = 3 AND a.is_zb = 0';

        if (!empty($keyword)) {
            $baseQuery .= ' AND a.title LIKE "%'.addslashes($keyword).'%"';
        }

        $baseQuery .= ' UNION ALL 
                      SELECT a.id, a.title, a.description, IFNULL(b.fileurl, "") as thumb, a.createtime, "" as username, "xm" AS source 
                      FROM fj_project a
                      LEFT JOIN fj_system_upload_file b ON a.thumb = b.fileid 
                      WHERE a.sh_status = 2 AND a.status = 1 AND a.put_end_time > '.$currentTime;

        if (!empty($keyword)) {
            $baseQuery .= ' AND a.title LIKE "%'.addslashes($keyword).'%"';
        }

        $baseQuery .= ' UNION ALL 
                      SELECT a.id, a.title, a.description, IFNULL(b.fileurl, "") as thumb, a.createtime, "" as username, "zs" AS source 
                      FROM fj_cert a
                      LEFT JOIN fj_system_upload_file b ON a.thumb_id = b.fileid 
                      WHERE a.is_sell = 1 AND a.is_del = 0';

        if (!empty($keyword)) {
            $baseQuery .= ' AND a.title LIKE "%'.addslashes($keyword).'%"';
        }

        $baseQuery .= ' UNION ALL 
                      SELECT a.id, a.title, a.description, IFNULL(b.fileurl, "") as thumb, a.createtime, c.username as username, "xxzl" AS source 
                      FROM fj_study_information a
                      LEFT JOIN fj_system_upload_file b ON a.thumb = b.fileid
                      LEFT JOIN fj_user c ON a.user_id = c.id
                      WHERE a.is_sell = 1 AND a.deletetime IS NULL AND a.status = 2';

        if (!empty($keyword)) {
            $baseQuery .= ' AND a.title LIKE "%'.addslashes($keyword).'%"';
        }

        $baseQuery .= ') AS combined';
        $query = Db::table($baseQuery)->order('createtime', 'desc');

        $list = $query->paginate([
            'list_rows' => $pageSize,
            'page' => $page,
        ]);

        $paginateData = $list->toArray();

        Cache::set($cacheKey, $paginateData, 300);

        return $this->returnMsg('success',1,$paginateData);
    }

    public function searchCourse()
    {
        $keyword = $this->request->param('searchKeyWords', '');
        $page = $this->request->param('page/d', 1);
        $pageSize = $this->request->param('pageSize/d', 10);

        $cacheKey = 'search_course_' . md5($keyword . '_' . $page . '_' . $pageSize);

        $cacheData = Cache::get($cacheKey);
        if ($cacheData !== null) {
            return $this->returnMsg('success', 1, $cacheData);
        }

        $query = Db::table('fj_course a')
            ->leftJoin('fj_system_upload_file b', 'a.thumb = b.fileid')
            ->leftJoin('fj_course_teacher c', 'a.teacher_id = c.id')
            ->field('a.id, a.title, a.description, IFNULL(b.fileurl, "") as thumb, a.createtime, c.nickname as username, "kc" AS source')
            ->where('a.is_sell', 1)
            ->where('a.is_del', 0)
            ->where('a.status', 3)
            ->where('a.is_zb', 0)
            ->order('a.createtime', 'desc');

        if (!empty($keyword)) {
            $query->where('a.title', 'like', "%{$keyword}%");
        }

        $list = $query->paginate([
            'list_rows' => $pageSize,
            'page' => $page,
        ]);

        $paginateData = $list->toArray();

        Cache::set($cacheKey, $paginateData, 300);

        return $this->returnMsg('success', 1, $paginateData);
    }

    public function searchStudy()
    {
        $keyword = $this->request->param('searchKeyWords', '');
        $page = $this->request->param('page/d', 1);
        $pageSize = $this->request->param('pageSize/d', 10);

        $cacheKey = 'search_study_' . md5($keyword . '_' . $page . '_' . $pageSize);

        $cacheData = Cache::get($cacheKey);
        if ($cacheData !== null) {
            return $this->returnMsg('success', 1, $cacheData);
        }

        $query = Db::table('fj_study_information a')
            ->leftJoin('fj_system_upload_file b', 'a.thumb = b.fileid')
            ->leftJoin('fj_user c', 'a.user_id = c.id')
            ->field('a.id, a.title, a.description, IFNULL(b.fileurl, "") as thumb, a.createtime, c.username as username, "xxzl" AS source')
            ->where('a.is_sell', 1)
            ->whereNull('a.deletetime')
            ->where('a.status', 2)
            ->order('a.createtime', 'desc');

        if (!empty($keyword)) {
            $query->where('a.title', 'like', "%{$keyword}%");
        }

        $list = $query->paginate([
            'list_rows' => $pageSize,
            'page' => $page,
        ]);

        $paginateData = $list->toArray();

        Cache::set($cacheKey, $paginateData, 300);

        return $this->returnMsg('success', 1, $paginateData);
    }

    public function searchProject()
    {
        $keyword = $this->request->param('searchKeyWords', '');
        $page = $this->request->param('page/d', 1);
        $pageSize = $this->request->param('pageSize/d', 10);
        $currentTime = time();

        $cacheKey = 'search_project_' . md5($keyword . '_' . $page . '_' . $pageSize);

        $cacheData = Cache::get($cacheKey);
        if ($cacheData !== null) {
            return $this->returnMsg('success', 1, $cacheData);
        }

        $query = Db::table('fj_project a')
            ->leftJoin('fj_system_upload_file b', 'a.thumb = b.fileid')
            ->field('a.id, a.title, a.description, IFNULL(b.fileurl, "") as thumb, a.createtime, "" as username, "xm" AS source')
            ->where('a.sh_status', 2)
            ->where('a.status', 1)
            ->where('a.put_end_time', '>', $currentTime)
            ->order('a.createtime', 'desc');

        if (!empty($keyword)) {
            $query->where('a.title', 'like', "%{$keyword}%");
        }

        $list = $query->paginate([
            'list_rows' => $pageSize,
            'page' => $page,
        ]);

        $paginateData = $list->toArray();

        Cache::set($cacheKey, $paginateData, 300);

        return $this->returnMsg('success', 1, $paginateData);
    }

    public function searchCert()
    {
        $keyword = $this->request->param('searchKeyWords', '');
        $page = $this->request->param('page/d', 1);
        $pageSize = $this->request->param('pageSize/d', 10);

        $cacheKey = 'search_cert_' . md5($keyword . '_' . $page . '_' . $pageSize);

        $cacheData = Cache::get($cacheKey);
        if ($cacheData !== null) {
            return $this->returnMsg('success', 1, $cacheData);
        }

        $query = Db::table('fj_cert a')
            ->leftJoin('fj_system_upload_file b', 'a.thumb_id = b.fileid')
            ->field('a.id, a.title, a.description, IFNULL(b.fileurl, "") as thumb, a.createtime, "" as username, "zs" AS source')
            ->where('a.is_sell', 1)
            ->where('a.is_del', 0)
            ->order('a.createtime', 'desc');

        if (!empty($keyword)) {
            $query->where('a.title', 'like', "%{$keyword}%");
        }

        $list = $query->paginate([
            'list_rows' => $pageSize,
            'page' => $page,
        ]);

        $paginateData = $list->toArray();

        Cache::set($cacheKey, $paginateData, 300);

        return $this->returnMsg('success', 1, $paginateData);
    }

    /**
     * 清除搜索缓存
     */
    public function clearSearchCache()
    {
        $pattern = 'search_plus_*';
        Cache::tag('search_plus')->clear();
        return $this->returnMsg('缓存清除成功', 1);
    }
}