<?php

namespace app\api\controller\manage;

use app\api\middleware\Auth;
use app\api\validate\ShCourseClassCategoryValidate;
use app\BaseController;
use app\model\ShCourse;
use app\model\ShCourseClassCategory as ShCourseCategoryModel;
use app\Request;

class ShCourseClassCategory extends BaseController
{

    protected $middleware = [
        Auth::class,
    ];

    //添加章节
    public function createShCourseClassCategory(Request $request)
    {

        $vo = (new ShCourseClassCategoryValidate())->goCheck(['course_id','title']);
        if ($vo !== true) {
            return $vo;
        }
        $parm = $request->param();
        $parm['createtime'] = time();
        $parm['user_id'] = $request->userId;
        $result = ShCourseCategoryModel::create($parm);
        if($result){
            ShCourse::where('id', $parm['course_id'])->update(['status' => 0]); //待提交
        }
        return $this->returnMsg('操作成功', 1, $result);
    }

    //修改章节
    public function editShCourseClassCategory(Request $request)
    {
        $vo = (new ShCourseClassCategoryValidate())->goCheck(['course_id', 'title','cate_id']);
        if ($vo !== true) {
            return $vo;
        }
        $parm = $request->param();
        $udpatedata = $parm;
        unset($udpatedata['cate_id']);
        $result = ShCourseCategoryModel::where(['user_id' => $request->userId, 'id' => $parm['cate_id']])->update($udpatedata);
        if($result){
            ShCourse::where('id', $parm['course_id'])->update(['status' => 0]); //待提交
        }
        return $this->returnMsg('操作成功', 1, $result);
    }
    //章节列表
    public function ShCourseClassCategoryList(Request $request)
    {
        $parm = $request->param();
        $where = ['is_del' => 0, 'user_id' => $request->userId];
        $map = [];
        if (isset($parm['searchKeyWords']) && $parm['searchKeyWords']) {
            $map[] = ['title', 'like', '%' . $parm['searchKeyWords'] . '%'];
        }

        if(isset($parm['course_id']) && $parm['course_id']){
            $map[] = ['course_id', '=', $parm['course_id']];
        }
        $page = $request->param('page', 1);
        $pageSize = $request->param('pageSize', 10);
        $list = ShCourseCategoryModel::where($where)->where($map)
            ->order('createtime desc')
            ->append(['course_title'])
            ->paginate([
                'page' => $page,
                'list_rows' => $pageSize
            ]);

        return $this->returnMsg('success', 1, $list);
    }

    //删除章节
    public function deleteShCourseClassCategory(Request $request)
    {

        $vo = (new ShCourseClassCategoryValidate())->goCheck(['cate_id']);
        if ($vo !== true) {
            return $vo;
        }
        $parm = $request->param();
        $where = ['id' => $parm['cate_id'], 'user_id' => $request->userId];
        $result = ShCourseCategoryModel::where($where)->update(['is_del' => 1]);
        $course_id = ShCourseCategoryModel::where(['id' => $parm['cate_id']])->value('course_id');
        event('Course', ['course_id' => $course_id, 'tasktype' => 'course', 'action' => 'shcourseupdate']); //同步数据
        return $this->returnMsg('操作成功', 1, $result);
    }

    //章节详情
    public function detailShCourseClassCategory(Request $request)
    {
        $vo = (new ShCourseClassCategoryValidate())->goCheck(['cate_id']);
        if ($vo !== true) {
            return $vo;
        }
        $parm = $request->param();
        $info = ShCourseCategoryModel::find($parm['cate_id'])->append(['course_title']);
        return $this->returnMsg('success', 1, $info);
    }


}