<?php

namespace app\api\controller\project;

use app\api\middleware\Auth;
use app\api\service\UtilService;
use app\api\validate\ProjectValidate;
use app\BaseController;
use think\Request;
use app\model\ProjectPut as ProjectPutModel;
use app\model\Project as ProjectModel;


class ProjectPut extends BaseController
{

    protected $middleware = [
        Auth::class,
    ];


    public function projectPut(Request $request)
    {

        $vo = (new ProjectValidate())->goCheck(['project_id','user_desc']);
        if ($vo !== true) {
            return $vo;
        }

        $data = $request->only(['project_id','user_desc','file_id_str']);

        $userRole = UtilService::checkUserRole($request->userId);
        if ($userRole!=1)
        {
            return json(['code' => 0, 'msg' => '企业账号不能申请']);
        }

        $projectData = ProjectModel::where(['id'=>$data['project_id']])->find();
        if ($projectData['status']!=1)
        {
            return $this->returnMsg('项目状态错误');
        }
        if ($projectData['put_end_time']<time())
        {
            return $this->returnMsg('项目已结束');
        }

        $count = ProjectPutModel::where(['project_id'=>$data['project_id'],'user_id'=>$request->userId])->count();
        if($count)
        {
            return $this->returnMsg('不可重复提交');
        }


        (new ProjectPutModel())->putProject($data,$request->userId);


        return $this->returnMsg('success',1);

    }

}