<?php

namespace app\model\project;

use app\model\system\SystemUploadFile;
use think\Model;

class School extends Model
{
    protected $name = 'school';

    protected $autoWriteTimestamp = true;

    protected $createTime = 'create_time';

    //学校资质id
    public function schoolQualification()
    {
        return $this->hasOne(SystemUploadFile::class, 'fileid', 'school_qualification_url_id')
            ->field('fileid,filename,filesize,fileurl,filetype');
    }

    //导师资质
    public function teacherQualification()
    {
        return $this->hasOne(SystemUploadFile::class, 'fileid', 'teacher_qualification_url_id')
            ->field('fileid, filename, filesize, fileurl, filetype');
    }

    //合作协议
    public function agreement()
    {
        return $this->hasOne(SystemUploadFile::class, 'fileid', 'agreement_url_id')
            ->field('fileid, filename, filesize, fileurl, filetype');
    }

    //补充材料
    public function moreFile()
    {
        return $this->hasOne(SystemUploadFile::class, 'fileid', 'more_url_id')
            ->field('fileid, filename, filesize, fileurl, filetype');
    }
}