<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\model;

use app\api\service\UserService;
use app\model\system\SystemUploadFile;
use think\facade\Db;
use think\Model;

/**
 * 模型公用类
 */
class Course extends Model
{

    /**获取推荐课程列表
     * @return Course[]|array|\think\Collection
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public  function getRecommendList()
    {
        return self::where(['status'=>3,'is_sell'=>1,'is_del'=>0])
            ->order('click,tvclick,createtime','desc')
            ->field('id,thumb,title')
            ->limit(5)
            ->select();
    }

    /**获取分类下的课程列表
     * @param $cate_id
     * @return Course[]|array|\think\Collection
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function getCourseList($cate_id = 0)
    {
        $where = ['status'=>3,'is_sell'=>1,'is_del'=>0];
        if ($cate_id)
        {
            $where['cate_id'] = $cate_id;
        }

        return self::where($where)
            ->field('id,thumb,title,createtime,description,price,content')
            ->select();
    }

    //获取课程详情
    public function getCouresDetail($course_id = 0)
    {
//        $where = ['status'=>3,'is_sell'=>1,'is_del'=>0];
        if ($course_id)
        {
            $where['id'] = $course_id;
        }

        $detail = self::where($where)
            ->with(['getTeacher'])
            ->field('id,thumb,title,createtime,description,price,content,teacher_id,tvclick,click')
            ->find();
        $detail['is_learned'] = 0; //是否学习
        $detail['is_buy'] = 0; //是否购买

        $token = request()->header('token');

        $user  = UserService::getUserInfo($token);

        if ($user)
        {
            $detail['is_learned'] = CourseProgress::where(['course_id'=>$detail['id'],'user_id'=>$user['id']])->count();
        }


        return $detail;
    }

    //关联教师
    public function getTeacher()
    {
        return $this->hasOne(CourseTeacher::class, 'id', 'teacher_id')
            ->field('id,nickname,description');
    }

    //关联章节
    public function getSections()
    {
        return $this->hasMany(CourseClassCategory::class, 'course_id','id')
            ->where('is_del',0)
            ->order('sort','asc')
            ->field('id,title,course_id');
    }

    //关联课时
    public function getCourseClass()
    {
        return $this->hasMany(\app\model\CourseClass::class, 'course_id','id')
            ->where('is_del',0)
            ->order('sort','asc');
    }

    //封面图
    public function thumb()
    {
        return $this->hasOne(SystemUploadFile::class, 'fileid', 'thumb')
            ->field('fileid,filename,filesize,fileurl,filetype');
    }


}