<?php

namespace app\model;

use app\model\project\User;
use think\Model;

class CourseProgress extends Model
{

    // 设置完整表名
    protected $table = 'fj_course_progress';

    // 自动时间戳（将createtime转换为时间戳自动管理）
    protected $autoWriteTimestamp = true;
    protected $createTime = 'createtime';
    protected $updateTime = 'updatetime';

    // 关联课程
    public function course()
    {
        return $this->belongsTo(Course::class, 'course_id');
    }

    // 关联章节（课时）
    public function class()
    {
        return $this->belongsTo(CourseClass::class, 'class_id');
    }

    // 关联用户
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

}