<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\model;

use app\model\project\User;
use app\model\system\SystemUploadFile;
use think\facade\Db;
use think\Model;

/**
 * 课程模型
 */
class ProjectPut extends Model
{

    protected $type = [
        'complete_time' => 'timestamp:Y-m-d H:i:s',
        'complete_post_time' => 'timestamp:Y-m-d H:i:s',
        'put_time' => 'timestamp:Y-m-d H:i:s',
    ];

    public function getCreatetimeAttr($value)
    {
        return date('Y-m-d H:i:s', $value);
    }


    public function getFileIdStrAttr($value, $data)
    {
        return get_upload_file($data['file_id_str'],'list');
    }

    public function getCompleteFileIdStrAttr($value, $data)
    {
        return get_upload_file($data['complete_file_id_str'],'list');
    }



    //用户信息
    public function getuserdata()
    {
        return $this->belongsTo(User::class, 'user_id')
            ->field('username,mobile,id');
    }


    public function getStatusTextAttr($value, $data)
    {
        switch ($data['status']) {
            case 1:
                $statustxt = '申请失败';
                break;
            case 2:
                $statustxt = '申请成功';
                break;
            default:
                $statustxt = '申请中';
        }

        return $statustxt;
    }

    public function getCompleteStatusTextAttr($value, $data)
    {
        switch ($data['complete_status']) {
            case 1:
                $statustxt = '验收中';
                break;
            case 2:
                $statustxt = '验收失败';
                break;
            case 3:
                $statustxt = '验收成功';
                break;
            default:
                $statustxt = '未上传';
        }

        return $statustxt;
    }

    public function putProject($data,$userId)
    {
        $data['user_id'] = $userId;
        $data['createtime'] = time();

        $res = self::create($data);

        return $res;
    }

    public function project()
    {
        return $this->belongsTo(Project::class, 'project_id', 'id')->field('id,sn,title,yusuan,user_id,zhouqi,description,content');
    }

}