DROP TABLE IF EXISTS `__PREFIX__build_module`;
CREATE TABLE `__PREFIX__build_module` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '类型ID',
  `name` varchar(30) NOT NULL DEFAULT '' COMMENT '模块标识',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '模块名称',
  `controller` varchar(30) NOT NULL DEFAULT '' COMMENT '控制器名称',
  `table` varchar(30) NOT NULL DEFAULT '' COMMENT '数据表名',
  `appdir` varchar(30) NOT NULL DEFAULT '' COMMENT '应用目录',
  `subdir` varchar(30) NOT NULL DEFAULT '' COMMENT '子级目录',
  `addtime` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `edittime` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '编辑时间',
  `runtime` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '生成时间',
  `times` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '生成次数',
  `add` varchar(30) NOT NULL DEFAULT '' COMMENT '创建者',
  `edit` varchar(30) NOT NULL DEFAULT '' COMMENT '编辑者',
  `run` varchar(30) NOT NULL DEFAULT '' COMMENT '生成者',
  `table_fields` text NOT NULL COMMENT '数据表字段设置',
  `table_engine` varchar(30) NOT NULL DEFAULT '' COMMENT '表引擎',
  `table_charset` varchar(30) NOT NULL DEFAULT '' COMMENT '表字符集',
  `table_size` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '表格尺寸0sm|1md|2lg',
  `form_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '标题和表单项的排列方式:1水平2垂直',
  `excelout` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '导出0关闭1开启',
  `excelup` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '导入0关闭1开启',
  `do_build` tinyint(1) unsigned NOT NULL DEFAULT '3' COMMENT '0都不生成1只生成数据表2只生成菜单3全部生成',
  `menu_pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级菜单ID',
  `open_size` varchar(50) NOT NULL DEFAULT '' COMMENT '弹窗尺寸',
  `dict_load` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '数据变化时是否更新前端字典数据缓存',
  `state` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态：0停用1启用',
  `note` text NOT NULL COMMENT '备注',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`) USING BTREE,
  UNIQUE KEY `table` (`table`) USING BTREE,
  KEY `controller` (`controller`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='模块记录';

INSERT INTO `__PREFIX__build_module` VALUES ('1', '0', 'project168', '案例', 'index', 'project', 'admin', 'project', '1714317000', '1720773534', '0', '8', 'admin', 'admin', '', '[{\"field\":\"id\",\"comment\":\"ID\",\"type\":\"bigint\",\"ttype\":\"text\",\"ttitle\":\"\",\"twidth\":\"50\",\"talign\":\"center\",\"tsort\":1,\"itype\":\"0\",\"ftype\":\"hidden\",\"ftitle\":\"\",\"default\":\"0\",\"length\":\"20\",\"notnull\":\"1\",\"primary\":1,\"inc\":1,\"unsigned\":1,\"dict\":\"\",\"search\":\"0\",\"match\":\"0\",\"order\":\"desc\",\"verifya\":\"/d/参数错误\",\"verify\":\"\",\"reqtext\":\"\",\"value\":\"\",\"options\":\"\",\"relation\":\"\",\"filetype\":\"\",\"skin\":\"\",\"range\":\"0\",\"readonly\":\"0\",\"placeholder\":\"\",\"tips\":\"\",\"html\":\"\",\"style\":\"\",\"itemStyle\":\"\",\"maxlength\":\"\",\"itemCol\":\"\",\"thOrder\":\"20\",\"infoOrder\":\"0\",\"formOrder\":\"0\",\"upout\":\"0\"},{\"field\":\"title\",\"comment\":\"名称\",\"type\":\"varchar\",\"ttype\":\"info\",\"ttitle\":\"\",\"twidth\":\"\",\"talign\":\"center\",\"tsort\":\"0\",\"itype\":\"1\",\"ftype\":\"text\",\"ftitle\":\"\",\"default\":\"\",\"length\":\"30\",\"notnull\":\"1\",\"primary\":\"0\",\"inc\":\"0\",\"unsigned\":\"0\",\"dict\":\"\",\"search\":\"1\",\"match\":\"0\",\"order\":\"\",\"verifya\":\"/h/名称\",\"verify\":\"required\",\"reqtext\":\"\",\"value\":\"\",\"options\":\"\",\"relation\":\"\",\"filetype\":\"\",\"skin\":\"\",\"range\":\"0\",\"readonly\":\"0\",\"placeholder\":\"请输入名称\",\"tips\":\"\",\"html\":\"\",\"style\":\"\",\"itemStyle\":\"\",\"maxlength\":\"\",\"itemCol\":\"\",\"thOrder\":\"0\",\"infoOrder\":\"0\",\"formOrder\":\"0\",\"upout\":\"3\"},{\"field\":\"catid\",\"comment\":\"类别\",\"type\":\"int\",\"ttype\":\"cattxt\",\"ttitle\":\"\",\"twidth\":\"\",\"talign\":\"center\",\"tsort\":\"0\",\"itype\":\"0\",\"ftype\":\"cattxt\",\"ftitle\":\"\",\"default\":\"0\",\"length\":\"10\",\"notnull\":\"1\",\"primary\":\"0\",\"inc\":\"0\",\"unsigned\":1,\"dict\":\"\",\"search\":\"9\",\"match\":\"0\",\"order\":\"\",\"verifya\":\"/d\",\"verify\":\"required\",\"reqtext\":\"请选择类别\",\"value\":\"\",\"options\":\"\",\"relation\":\"\",\"filetype\":\"\",\"skin\":\"\",\"range\":\"0\",\"readonly\":\"0\",\"placeholder\":\"\",\"tips\":\"\",\"html\":\"\",\"style\":\"\",\"itemStyle\":\"\",\"maxlength\":\"\",\"itemCol\":\"\",\"thOrder\":\"0\",\"infoOrder\":\"0\",\"formOrder\":\"0\",\"upout\":\"3\"},{\"field\":\"organ\",\"comment\":\"组织\",\"type\":\"varchar\",\"ttype\":\"dicttxt\",\"ttitle\":\"\",\"twidth\":\"\",\"talign\":\"center\",\"tsort\":\"0\",\"itype\":\"4\",\"ftype\":\"dict7\",\"ftitle\":\"\",\"default\":\"\",\"length\":\"100\",\"notnull\":\"1\",\"primary\":\"0\",\"inc\":\"0\",\"unsigned\":\"0\",\"dict\":\"ORGAN\",\"search\":\"6\",\"match\":\"8\",\"order\":\"\",\"verifya\":\"/*/i/组织\",\"verify\":\"required\",\"reqtext\":\"请选择组织\",\"value\":\"\",\"options\":\"\",\"relation\":\"\",\"filetype\":\"\",\"skin\":\"\",\"range\":\"0\",\"readonly\":\"0\",\"placeholder\":\"\",\"tips\":\"\",\"html\":\"\",\"style\":\"\",\"itemStyle\":\"\",\"maxlength\":\"\",\"itemCol\":\"\",\"thOrder\":\"0\",\"infoOrder\":\"0\",\"formOrder\":\"0\",\"upout\":\"0\"},{\"field\":\"areaid\",\"comment\":\"地区\",\"type\":\"varchar\",\"ttype\":\"areatxt\",\"ttitle\":\"\",\"twidth\":\"\",\"talign\":\"center\",\"tsort\":\"0\",\"itype\":\"3\",\"ftype\":\"areas\",\"ftitle\":\"\",\"default\":\"\",\"length\":\"50\",\"notnull\":\"1\",\"primary\":\"0\",\"inc\":\"0\",\"unsigned\":\"0\",\"dict\":\"\",\"search\":\"8\",\"match\":\"0\",\"order\":\"\",\"verifya\":\"/*/i/地区\",\"verify\":\"required\",\"reqtext\":\"请选择地区\",\"value\":\"\",\"options\":\"\",\"relation\":\"\",\"filetype\":\"\",\"skin\":\"\",\"range\":\"0\",\"readonly\":\"0\",\"placeholder\":\"\",\"tips\":\"\",\"html\":\"\",\"style\":\"\",\"itemStyle\":\"\",\"maxlength\":\"\",\"itemCol\":\"\",\"thOrder\":\"0\",\"infoOrder\":\"0\",\"formOrder\":\"0\",\"upout\":\"0\"},{\"field\":\"img\",\"comment\":\"配图\",\"type\":\"varchar\",\"ttype\":\"img\",\"ttitle\":\"\",\"twidth\":\"60\",\"talign\":\"center\",\"tsort\":\"0\",\"itype\":\"1\",\"ftype\":\"image\",\"ftitle\":\"\",\"default\":\"\",\"length\":\"300\",\"notnull\":\"1\",\"primary\":\"0\",\"inc\":\"0\",\"unsigned\":\"0\",\"dict\":\"\",\"search\":\"0\",\"match\":\"0\",\"order\":\"\",\"verifya\":\"/u\",\"verify\":\"required\",\"reqtext\":\"请上传图片\",\"value\":\"\",\"options\":\"\",\"relation\":\"\",\"filetype\":\"\",\"skin\":\"\",\"range\":\"0\",\"readonly\":\"0\",\"placeholder\":\"\",\"tips\":\"\",\"html\":\"\",\"style\":\"\",\"itemStyle\":\"\",\"maxlength\":\"\",\"itemCol\":\"\",\"thOrder\":\"19\",\"infoOrder\":\"0\",\"formOrder\":\"0\",\"upout\":\"0\"},{\"field\":\"imgs\",\"comment\":\"图集\",\"type\":\"varchar\",\"ttype\":\"none\",\"ttitle\":\"\",\"twidth\":\"\",\"talign\":\"center\",\"tsort\":\"0\",\"itype\":\"1\",\"ftype\":\"images\",\"ftitle\":\"\",\"default\":\"\",\"length\":\"2000\",\"notnull\":\"1\",\"primary\":\"0\",\"inc\":\"0\",\"unsigned\":\"0\",\"dict\":\"\",\"search\":\"0\",\"match\":\"0\",\"order\":\"\",\"verifya\":\"/a/请上传图集\",\"verify\":\"required\",\"reqtext\":\"请上传图集\",\"value\":\"\",\"options\":\"\",\"relation\":\"\",\"filetype\":\"\",\"skin\":\"\",\"range\":\"0\",\"readonly\":\"0\",\"placeholder\":\"\",\"tips\":\"\",\"html\":\"\",\"style\":\"\",\"itemStyle\":\"\",\"maxlength\":\"\",\"itemCol\":\"\",\"thOrder\":\"0\",\"infoOrder\":\"0\",\"formOrder\":\"0\",\"upout\":\"0\"},{\"field\":\"files\",\"comment\":\"附件\",\"type\":\"varchar\",\"ttype\":\"none\",\"ttitle\":\"\",\"twidth\":\"\",\"talign\":\"center\",\"tsort\":\"0\",\"itype\":\"0\",\"ftype\":\"upfile\",\"ftitle\":\"\",\"default\":\"\",\"length\":\"100\",\"notnull\":\"1\",\"primary\":\"0\",\"inc\":\"0\",\"unsigned\":\"0\",\"dict\":\"\",\"search\":\"0\",\"match\":\"0\",\"order\":\"\",\"verifya\":\"/u\",\"verify\":\"\",\"reqtext\":\"\",\"value\":\"\",\"options\":\"\",\"relation\":\"\",\"filetype\":\"\",\"skin\":\"\",\"range\":\"0\",\"readonly\":\"0\",\"placeholder\":\"\",\"tips\":\"\",\"html\":\"\",\"style\":\"\",\"itemStyle\":\"\",\"maxlength\":\"\",\"itemCol\":\"\",\"thOrder\":\"0\",\"infoOrder\":\"0\",\"formOrder\":\"0\",\"upout\":\"0\"},{\"field\":\"hit\",\"comment\":\"阅读\",\"type\":\"int\",\"ttype\":\"text\",\"ttitle\":\"\",\"twidth\":\"60\",\"talign\":\"center\",\"tsort\":\"0\",\"itype\":\"0\",\"ftype\":\"number\",\"ftitle\":\"\",\"default\":\"0\",\"length\":\"10\",\"notnull\":\"1\",\"primary\":\"0\",\"inc\":\"0\",\"unsigned\":1,\"dict\":\"\",\"search\":\"0\",\"match\":\"0\",\"order\":\"\",\"verifya\":\"/d\",\"verify\":\"\",\"reqtext\":\"\",\"value\":\"0\",\"options\":\"\",\"relation\":\"\",\"filetype\":\"\",\"skin\":\"\",\"range\":\"0\",\"readonly\":\"0\",\"placeholder\":\"\",\"tips\":\"\",\"html\":\"\",\"style\":\"\",\"itemStyle\":\"\",\"maxlength\":\"\",\"itemCol\":\"layui-col-md6\",\"thOrder\":\"0\",\"infoOrder\":\"0\",\"formOrder\":\"0\",\"upout\":\"0\"},{\"field\":\"endtime\",\"comment\":\"有效期至\",\"type\":\"int\",\"ttype\":\"ymd\",\"ttitle\":\"\",\"twidth\":\"\",\"talign\":\"center\",\"tsort\":\"0\",\"itype\":\"1\",\"ftype\":\"date\",\"ftitle\":\"\",\"default\":\"0\",\"length\":\"11\",\"notnull\":\"1\",\"primary\":\"0\",\"inc\":\"0\",\"unsigned\":1,\"dict\":\"\",\"search\":\"0\",\"match\":\"0\",\"order\":\"\",\"verifya\":\"/d\",\"verify\":\"required\",\"reqtext\":\"\",\"value\":\"\",\"options\":\"\",\"relation\":\"\",\"filetype\":\"\",\"skin\":\"\",\"range\":\"0\",\"readonly\":\"0\",\"placeholder\":\"请选择有效期\",\"tips\":\"\",\"html\":\"\",\"style\":\"\",\"itemStyle\":\"\",\"maxlength\":\"\",\"itemCol\":\"layui-col-md6\",\"thOrder\":\"0\",\"infoOrder\":\"0\",\"formOrder\":\"0\",\"upout\":\"0\"},{\"field\":\"info\",\"comment\":\"概要\",\"type\":\"varchar\",\"ttype\":\"text\",\"ttitle\":\"\",\"twidth\":\"\",\"talign\":\"center\",\"tsort\":\"0\",\"itype\":\"1\",\"ftype\":\"textarea\",\"ftitle\":\"\",\"default\":\"\",\"length\":\"200\",\"notnull\":\"1\",\"primary\":\"0\",\"inc\":\"0\",\"unsigned\":\"0\",\"dict\":\"\",\"search\":\"1\",\"match\":\"8\",\"order\":\"\",\"verifya\":\"/h\",\"verify\":\"\",\"reqtext\":\"\",\"value\":\"\",\"options\":\"\",\"relation\":\"\",\"filetype\":\"\",\"skin\":\"\",\"range\":\"0\",\"readonly\":\"0\",\"placeholder\":\"\",\"tips\":\"\",\"html\":\"\",\"style\":\"\",\"itemStyle\":\"\",\"maxlength\":\"\",\"itemCol\":\"\",\"thOrder\":\"0\",\"infoOrder\":\"0\",\"formOrder\":\"0\",\"upout\":\"3\"},{\"field\":\"content\",\"comment\":\"内容\",\"type\":\"text\",\"ttype\":\"none\",\"ttitle\":\"\",\"twidth\":\"\",\"talign\":\"center\",\"tsort\":\"0\",\"itype\":\"2\",\"ftype\":\"ueditor\",\"ftitle\":\"\",\"default\":\"\",\"length\":\"0\",\"notnull\":\"1\",\"primary\":\"0\",\"inc\":\"0\",\"unsigned\":\"0\",\"dict\":\"\",\"search\":\"2\",\"match\":\"8\",\"order\":\"\",\"verifya\":\"\",\"verify\":\"\",\"reqtext\":\"\",\"value\":\"\",\"options\":\"\",\"relation\":\"\",\"filetype\":\"\",\"skin\":\"\",\"range\":\"0\",\"readonly\":\"0\",\"placeholder\":\"\",\"tips\":\"\",\"html\":\"\",\"style\":\"\",\"itemStyle\":\"\",\"maxlength\":\"\",\"itemCol\":\"\",\"thOrder\":\"0\",\"infoOrder\":\"0\",\"formOrder\":\"0\",\"upout\":\"3\"},{\"field\":\"add\",\"comment\":\"添加者\",\"type\":\"varchar\",\"ttype\":\"text\",\"ttitle\":\"\",\"twidth\":\"\",\"talign\":\"center\",\"tsort\":\"0\",\"itype\":\"1\",\"ftype\":\"none\",\"ftitle\":\"\",\"default\":\"VT_USER\",\"length\":\"30\",\"notnull\":\"1\",\"primary\":\"0\",\"inc\":\"0\",\"unsigned\":\"0\",\"dict\":\"\",\"search\":\"1\",\"match\":\"0\",\"order\":\"\",\"verifya\":\"\",\"verify\":\"\",\"reqtext\":\"\",\"value\":\"\",\"options\":\"\",\"relation\":\"\",\"filetype\":\"\",\"skin\":\"\",\"range\":\"0\",\"readonly\":\"0\",\"placeholder\":\"\",\"tips\":\"\",\"html\":\"\",\"style\":\"\",\"itemStyle\":\"\",\"maxlength\":\"\",\"itemCol\":\"\",\"thOrder\":\"0\",\"infoOrder\":\"0\",\"formOrder\":\"0\",\"upout\":\"3\"},{\"field\":\"addtime\",\"comment\":\"添加时间\",\"type\":\"int\",\"ttype\":\"time\",\"ttitle\":\"\",\"twidth\":\"\",\"talign\":\"center\",\"tsort\":\"0\",\"itype\":\"6\",\"ftype\":\"none\",\"ftitle\":\"\",\"default\":\"VT_TIME\",\"length\":\"11\",\"notnull\":\"1\",\"primary\":\"0\",\"inc\":\"0\",\"unsigned\":1,\"dict\":\"\",\"search\":\"3\",\"match\":\"0\",\"order\":\"\",\"verifya\":\"\",\"verify\":\"\",\"reqtext\":\"\",\"value\":\"\",\"options\":\"\",\"relation\":\"\",\"filetype\":\"\",\"skin\":\"\",\"range\":\"0\",\"readonly\":\"0\",\"placeholder\":\"\",\"tips\":\"\",\"html\":\"\",\"style\":\"\",\"itemStyle\":\"\",\"maxlength\":\"\",\"itemCol\":\"\",\"thOrder\":\"0\",\"infoOrder\":\"0\",\"formOrder\":\"0\",\"upout\":\"0\"},{\"field\":\"edit\",\"comment\":\"编辑者\",\"type\":\"varchar\",\"ttype\":\"none\",\"ttitle\":\"\",\"twidth\":\"\",\"talign\":\"center\",\"tsort\":\"0\",\"itype\":\"1\",\"ftype\":\"none\",\"ftitle\":\"\",\"default\":\"@VT_USER\",\"length\":\"30\",\"notnull\":\"1\",\"primary\":\"0\",\"inc\":\"0\",\"unsigned\":\"0\",\"dict\":\"\",\"search\":\"0\",\"match\":\"0\",\"order\":\"\",\"verifya\":\"\",\"verify\":\"\",\"reqtext\":\"\",\"value\":\"\",\"options\":\"\",\"relation\":\"\",\"filetype\":\"\",\"skin\":\"\",\"range\":\"0\",\"readonly\":\"0\",\"placeholder\":\"\",\"tips\":\"\",\"html\":\"\",\"style\":\"\",\"itemStyle\":\"\",\"maxlength\":\"\",\"itemCol\":\"\",\"thOrder\":\"0\",\"infoOrder\":\"0\",\"formOrder\":\"0\",\"upout\":\"3\"},{\"field\":\"edittime\",\"comment\":\"编辑时间\",\"type\":\"int\",\"ttype\":\"none\",\"ttitle\":\"\",\"twidth\":\"\",\"talign\":\"center\",\"tsort\":\"0\",\"itype\":\"6\",\"ftype\":\"none\",\"ftitle\":\"\",\"default\":\"@VT_TIME\",\"length\":\"11\",\"notnull\":\"1\",\"primary\":\"0\",\"inc\":\"0\",\"unsigned\":1,\"dict\":\"\",\"search\":\"0\",\"match\":\"0\",\"order\":\"\",\"verifya\":\"\",\"verify\":\"\",\"reqtext\":\"\",\"value\":\"\",\"options\":\"\",\"relation\":\"\",\"filetype\":\"\",\"skin\":\"\",\"range\":\"0\",\"readonly\":\"0\",\"placeholder\":\"\",\"tips\":\"\",\"html\":\"\",\"style\":\"\",\"itemStyle\":\"\",\"maxlength\":\"\",\"itemCol\":\"\",\"thOrder\":\"0\",\"infoOrder\":\"0\",\"formOrder\":\"0\",\"upout\":\"0\"},{\"field\":\"listorder\",\"comment\":\"排序\",\"type\":\"int\",\"ttype\":\"edit\",\"ttitle\":\"\",\"twidth\":\"80\",\"talign\":\"center\",\"tsort\":\"0\",\"itype\":\"1\",\"ftype\":\"number\",\"ftitle\":\"\",\"default\":\"0\",\"length\":\"10\",\"notnull\":\"1\",\"primary\":\"0\",\"inc\":\"0\",\"unsigned\":1,\"dict\":\"\",\"search\":\"0\",\"match\":\"0\",\"order\":\"1asc\",\"verifya\":\"/d\",\"verify\":\"\",\"reqtext\":\"\",\"value\":\"10\",\"options\":\"\",\"relation\":\"\",\"filetype\":\"\",\"skin\":\"\",\"range\":\"0\",\"readonly\":\"0\",\"placeholder\":\"\",\"tips\":\"\",\"html\":\"\",\"style\":\"\",\"itemStyle\":\"\",\"maxlength\":\"\",\"itemCol\":\"\",\"thOrder\":\"0\",\"infoOrder\":\"0\",\"formOrder\":\"0\",\"upout\":\"0\"},{\"field\":\"state\",\"comment\":\"状态\",\"type\":\"tinyint\",\"ttype\":\"checkbox\",\"ttitle\":\"\",\"twidth\":\"80\",\"talign\":\"center\",\"tsort\":\"0\",\"itype\":\"1\",\"ftype\":\"switch\",\"ftitle\":\"\",\"default\":\"1\",\"length\":\"1\",\"notnull\":\"1\",\"primary\":\"0\",\"inc\":\"0\",\"unsigned\":1,\"dict\":\"\",\"search\":\"4\",\"match\":\"0\",\"order\":\"\",\"verifya\":\"/d\",\"verify\":\"\",\"reqtext\":\"\",\"value\":\"1\",\"options\":\"\",\"relation\":\"\",\"filetype\":\"\",\"skin\":\"\",\"range\":\"0\",\"readonly\":\"0\",\"placeholder\":\"\",\"tips\":\"\",\"html\":\"\",\"style\":\"\",\"itemStyle\":\"\",\"maxlength\":\"\",\"itemCol\":\"\",\"thOrder\":\"0\",\"infoOrder\":\"0\",\"formOrder\":\"0\",\"upout\":\"3\"}]', 'InnoDB', 'utf8', '1', '1', '0', '0', '3', '0', '900px,95%', '0', '1', '');