<?php

namespace app\api\validate;

use think\Validate;

class CourseTeacherValidate extends BaseValidate
{
    protected $rule = [
        'nickname' => 'require',
        'mobile' => 'mobile',
        'idcard' => 'idCard',
        'teacher_id' => 'require',
        'description' => 'max:300',

    ];
    protected $message = [
        'nickname.require' => '讲师姓名不能为空',
        'teacher_id.require' => 'id不能为空',
        'mobile.mobile' => '手机号格式错误',
        'idcard.idCard' => '身份证格式错误',
        'description.max' => '讲师简介字数过长',
    ];

}