<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\model;

use app\api\service\UtilService;
use \app\model\CertCategory;
use app\model\project\User;
use app\model\system\SystemUploadFile;
use think\facade\Db;
use think\Model;

/**
 * 课程模型
 */
class Payment extends Model
{

    protected $autoWriteTimestamp = true;
    protected $createTime = 'createtime';


    //用户信息
    public function getuserdata()
    {
        return $this->belongsTo(User::class, 'user_id')
            ->field('username,mobile,id');
    }

    public function getPayMethodTextAttr($value, $data)
    {
        switch ($data['pay_method']) {
            case 2:
                $text = '微信';
                break;
            default:
                $text = '支付宝';
                break;
        }
        return $text;
    }

    public function getPayStatusTextAttr($value, $data)
    {
        switch ($data['pay_status']) {
            case 1:
                $text = '支付成功';
                break;
            case 2:
                $text = '支付失败';
                break;
            default:
                $text = '未支付';
                break;
        }
        return $text;
    }

    public function getPayTimeTextAttr($value, $data)
    {
        return date('Y-m-d H:i:s', $data['pay_time']);

    }

    public function getOrderNameAttr($value, $data)
    {
        $title = '';
        if ($data['order_type'] == 1) {
            //课程
//            $title = ShCourse::where('id', $data['order_id'])->value('title');
            $title = '购买课程：' . $data['subject'];
        } elseif ($data['order_type'] == 2) {
            //证书
//            $certinfo = Cert::where('id', $data['order_id'])->value('title');
            $title = '购买证书：' . $data['subject'];
        }
        return $title;
    }
    /**
     * 获取订单统计信息
     * @param string $range 时间范围: month(近一个月), quarter(近三个月), halfyear(近半年), year(近一年), all(全部)
     * @param int $userId 用户ID
     * @return array
     */
    public function getOrderStatistics($range = 'month', $userId = 0)
    {

        // 基础查询条件：支付成功(1)且订单类型为课程(1)
        $query = $this->where('pay_status', 1)
            ->where('order_type', 1)
            ->where('store_user_id', $userId);

        // 根据时间范围设置条件
        switch ($range) {
            case 'month':
                $startTime = strtotime('-1 month');
                $timeFormat = "%Y-%m-%d"; // 按天
                break;
            case 'quarter':
                $startTime = strtotime('-3 month');
                $timeFormat = "%Y-%m";    // 按月
                break;
            case 'halfyear':
                $startTime = strtotime('-6 month');
                $timeFormat = "%Y-%m";    // 按月
                break;
            case 'year':
                $startTime = strtotime('-12 month');
                $timeFormat = "%Y-%m";    // 按月
                break;
            case 'all':
            default:
                $startTime = strtotime('-5 year'); // 默认统计最近5年
                $timeFormat = "%Y-%m";    // 按月
                break;
        }

        if ($startTime) {
            $query->where('pay_time', '>=', $startTime);
        }

        // 按时间分组统计
        $result = $query->field([
            "FROM_UNIXTIME(pay_time, '{$timeFormat}') as time_period",
            "COUNT(*) as order_count",
            "SUM(pay_amount) as total_amount"
        ])
            ->group("time_period")
            ->order("time_period ASC")
            ->select()
            ->toArray();
        if ($range != 'all')
        {
            // 自动补全缺失的时间段数据
            $filledData = $this->fillMissingTimePeriods($result, $timeFormat, $startTime);
        }else{
            $filledData = $result;
        }


        return [
            'data' => $filledData,
            'format' => $timeFormat === "%Y-%m-%d" ? 'day' : 'month'
        ];
    }

    /**
     * 补全缺失的时间段数据（私有方法确保不会重复）
     */
    private function fillMissingTimePeriods($data, $timeFormat, $startTime)
    {

        if (empty($data)) {
            return [];
        }

        $filledData = [];
        $current = $startTime ?: strtotime($data[0]['time_period']);
        $end = strtotime('today 23:59:59');

        // 根据格式确定时间间隔
        $isDaily = ($timeFormat === "%Y-%m-%d");
        $interval = $isDaily ? '1 day' : '1 month';
        $dateFormat = $isDaily ? 'Y-m-d' : 'Y-m';

        while ($current <= $end) {
            $period = date($dateFormat, $current);
            $found = false;

            foreach ($data as $item) {
                if ($item['time_period'] === $period) {
                    $filledData[] = $item;
                    $found = true;
                    break;
                }
            }

            if (!$found) {
                $filledData[] = [
                    'time_period' => $period,
                    'order_count' => 0,
                    'total_amount' => 0.00
                ];
            }

            $current = strtotime("+{$interval}", $current);
        }

        return $filledData;
    }
}