<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\admin\controller\project;

use app\admin\controller\AdminBase;
use app\model\ProjectPut as ProjectPutModel;
use think\App;
use think\facade\Db;
use app\model\projectCategory;

/**
 * 后台主控制器
 */
class ProjectPut extends AdminBase
{

    protected $projectput;

    public function __construct(App $app)
    {
        parent::__construct($app);

        $this->projectput = new ProjectPutModel();

    }

    // 列表
    public function index(string $do = '')
    {

        $limit = 10;
        if ($do == 'json') {

            $post = input();
            $post['limit'] = isset($post['limit']) ? $post['limit'] : $limit;
            $map = [];
            $map[] = ['project_id', '=', $post['project_id']];

            $list = $this->projectput->where($map)->with(['getuserdata'])->append(['complete_status_text', 'status_text'])->order('createtime desc')->paginate($post['limit']);
            return $this->returnMsg($list);
        }

        $this->assign('limit', $limit);
        return $this->fetch('', '', false);
    }

    public function del()
    {
        $post = input();
        $ids = is_array($post['id']) ? implode(',', $post['id']) : $post['id'];
        if ($this->projectput->destroy([$ids])) {
            return $this->returnMsg("删除成功", 1);
        } else {
            return $this->returnMsg("删除失败");
        }
    }


    //详情
    public function detail()
    {
        $post = input();
        $info = $this->projectput->where('id', $post['id'])->find()->append(['file_id_str','complete_file_id_str']);
        $this->assign('info', $info);
        return $this->fetch('', '', false);
    }


    //审核
    public function shenheproject()
    {
        $post = input();
        $errordesc = '';
        $shstatus = 2;
        if ($post['shstatus'] == 2) {
            if (empty($post['errordesc'])) {
                return $this->returnMsg("请输入失败原因");
            }
            $errordesc = $post['errordesc'];
            $shstatus = 1;
            $updatedata['status'] = 0;
        }

        $updatedata['sh_status'] = $shstatus;
        $updatedata['sh_status_desc'] = $errordesc;

        $result = $this->projectput->where('id', $post['id'])->update($updatedata);
        if ($result) {
            return $this->returnMsg("操作成功", 1);
        } else {
            return $this->returnMsg("操作失败");
        }

    }
}