<?php

namespace app\job;

use app\model\Course as CourseModel;
use app\model\CourseClass;
use app\model\CourseClassCategory;
use app\model\CourseWork;
use app\model\ShCourse;
use app\model\project\Mail;
use app\model\ShCourseClass;
use app\model\ShCourseClassCategory;
use app\model\ShCourseWork;
use think\facade\Log;
use think\queue\Job;
use think\facade\Db;

class Jobtask
{

    public function fire(Job $job, $data)
    {

        //....这里执行具体的任务
        // 处理课程审核通过数据同步


        if ($data['tasktype'] == 'course') {
            Db::startTrans();
            try {
                $this->synccourse($data);
                Db::commit();
                $job->delete();
                Log::write('成功：' . json_encode($data));
            } catch (\Exception $e) {
                Db::rollback();
                Log::write('失败：' . $e->getMessage());
//                $job->release(); //$delay为延迟时间
            }
        }


//        if ($job->attempts() > 3) {
//            //通过这个方法可以检查这个任务已经重试了几次了
//        }
//
//        //如果任务执行成功后 记得删除任务，不然这个任务会重复执行，直到达到最大重试次数后失败后，执行failed方法

//
//        // 也可以重新发布这个任务
//        $job->release(); //$delay为延迟时间

    }

    public function failed($data)
    {
        Log::write('测试日志信息，失败');
        // ...任务达到最大重试次数后，失败了

    }

    public function synccourse($data)
    {

        if ($data['action'] == 'shstatus') {
            //更新课程
            $courseinfo = ShCourse::where('id', $data['course_id'])->find();
            $is_cz = CourseModel::where('id', $data['course_id'])->count();
            if ($is_cz > 0) {
                unset($courseinfo['click']);
                unset($courseinfo['tvclick']);
                CourseModel::update($courseinfo);
            } else {
                CourseModel::create($courseinfo); //添加课程
            }

            //处理课时
//            $course_class_list = ShCourseClass::where('course_id', $data['course_id'])->without(['tvfile'])->select();
            $course_class_list = Db::name('sh_course_class')->where('course_id', $data['course_id'])->select()->toArray();

            if ($course_class_list) {
//                CourseClass::where('course_id', $data['course_id'])->delete(); //删除课时
                CourseClass::saveAll($course_class_list); //添加课时
            }


            //处理章节
//            $course_class_category = ShCourseClassCategory::where('course_id', $data['course_id'])->select()->toArray();
            $course_class_category = Db::name('sh_course_class_category')->where('course_id', $data['course_id'])->select()->toArray();
            if ($course_class_category) {
//                CourseClassCategory::where('course_id', $data['course_id'])->delete(); //删除章节
                CourseClassCategory::saveAll($course_class_category); //添加章节
            }

            //处理作业
//            $course_work = ShCourseWork::where('course_id', $data['course_id'])->select()->toArray();
            $course_work = Db::name('sh_course_work')->where('course_id', $data['course_id'])->select()->toArray();
            if ($course_work) {
//                CourseWork::where('course_id', $data['course_id'])->delete(); //删除作业
                CourseWork::saveAll($course_work); //添加作业
            }


        } elseif ($data['action'] == 'shcourseupdate') {

            //更新状态数据 删除，上下架
            $courseinfo = Db::name('sh_course')->field('id,is_sell,is_del,is_hot,is_tj')->where('id', $data['course_id'])->find();
            Db::name('course')->where('id', $data['course_id'])->update($courseinfo);
            //处理课时
            $course_class_list = Db::name('sh_course_class')->field('id,is_del,is_sell,sort')->where('course_id', $data['course_id'])->select()->toArray();
            foreach ($course_class_list as $item) {
                Db::name('course_class')->update($item);
            }
            //处理章节
            $course_class_category = Db::name('sh_course_class_category')->field('id,is_del,sort')->where('course_id', $data['course_id'])->select()->toArray();

            foreach ($course_class_category as $item) {
                Db::name('course_class_category')->update($item);
            }
            //处理作业
            $course_work = Db::name('sh_course_work')->field('id,is_del')->where('course_id', $data['course_id'])->select()->toArray();
            foreach ($course_work as $item) {
                Db::name('course_work')->update($item);
            }

        } elseif ($data['action'] == 'courseupdateclick') {
            //更新销量阅读量
            $courseinfo = CourseModel::field('id,click,tvclick')->where('id', $data['course_id'])->find();
            ShCourse::update($courseinfo);
        }


    }

    //同步课程
    public function synccourse11111111111111($data)
    {
        if ($data['action'] == 'shstatus') {

            //更新课程
            $courseinfo = Db::name('sh_course')->where('id', $data['course_id'])->find();
            $is_cz = Db::name('course')->where('id', $data['course_id'])->count();
            if ($is_cz > 0) {
                unset($courseinfo['click']);
                unset($courseinfo['tvclick']);
                Db::name('course')->update($courseinfo);
            } else {
                Db::name('course')->insert($courseinfo); //添加课程
            }

            //处理课时
            $course_class_list = Db::name('sh_course_class')->where('course_id', $data['course_id'])->select()->toArray();
            Db::name('course_class')->where('course_id', $data['course_id'])->delete(); //删除课时
            Db::name('course_class')->insertAll($course_class_list); //添加课时

            //处理章节
            $course_class_category = Db::name('sh_course_class_category')->where('course_id', $data['course_id'])->select()->toArray();
            if ($course_class_category) {
                Db::name('course_class_category')->where('course_id', $data['course_id'])->delete(); //删除章节
                Db::name('course_class_category')->insertAll($course_class_category); //添加章节
            }

            //处理作业
            $course_work = Db::name('sh_course_work')->where('course_id', $data['course_id'])->select()->toArray();
            if ($course_work) {
                Db::name('course_work')->where('course_id', $data['course_id'])->delete(); //删除作业
                Db::name('course_work')->insertAll($course_work); //添加作业
            }


        } elseif ($data['action'] == 'shcourseupdate') {

            //更新状态数据 删除，上下架
            $courseinfo = Db::name('sh_course')->field('is_sell,is_del')->where('id', $data['course_id'])->find();
            Db::name('course')->where('id', $data['course_id'])->update($courseinfo);
            //处理课时
            $course_class_list = Db::name('sh_course_class')->field('id,is_del,is_sell')->where('course_id', $data['course_id'])->select()->toArray();
            foreach ($course_class_list as $item) {
                Db::name('course_class')->update($item);
            }
            //处理章节
            $course_class_category = Db::name('sh_course_class_category')->field('id,is_del')->where('course_id', $data['course_id'])->select()->toArray();
            foreach ($course_class_category as $item) {
                Db::name('course_class_category')->update($item);
            }
            //处理作业
            $course_work = Db::name('sh_course_work')->field('id,is_del')->where('course_id', $data['course_id'])->select()->toArray();
            foreach ($course_work as $item) {
                Db::name('course_work')->update($item);
            }

        } elseif ($data['action'] == 'courseupdateclick') {
            //更新销量阅读量
            $courseinfo = Db::name('course')->field('click,tvclick')->where('id', $data['course_id'])->find();
            Db::name('sh_course')->where('id', $data['course_id'])->update($courseinfo);
        }


    }

}