<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\admin\controller\cert;

use app\admin\controller\AdminBase;
use app\model\CertOrder as CertOrderModel;
use think\App;
/**
 * 后台主控制器
 */
class CertOrder extends AdminBase
{

    protected $certorder;

    public function __construct(App $app)
    {
        parent::__construct($app);

        $this->certorder = new CertOrderModel();

    }

    // 列表
    public function index(string $do = '')
    {

        $limit = 10;
        if ($do == 'json') {

            $post = input();
            $post['limit'] = isset($post['limit']) ? $post['limit'] : $limit;
            $map[] = ['cert_order.is_del', '=', 0];
            $map[] = ['cert_order.status', '>', 0];
            $hasmap = [];
            if (isset($post['kw']) && !empty($post['kw'])) {
                $hasmap[] = ['user.username|user.mobile', 'like', '%' . $post['kw'] . '%'];
            }
            $certmap = [];
            if (isset($post['cert_title']) && !empty($post['cert_title'])) {
                $certmap[] = ['cert.title', 'like', '%' . trim($post['cert_title']) . '%'];
            }
            if (isset($post['status']) && !empty($post['status'])) {
                $map[] = ['status', '=', $post['status']];
            }
            $list = $this->certorder->hasWhere('userprofile', $hasmap)->hasWhere('certdata', $certmap)->where($map)->with(['certdata','userprofile'])->append(['status_text'])->order('createtime desc')->paginate($post['limit']);
            return $this->returnMsg($list);
        }

        $this->assign('limit', $limit);
        return $this->fetch('', '', false);
    }

    //快速编辑
    public function editup()
    {

        $post = input();
        $result = $this->certorder->update([$post['af'] => $post['av']], [['id', '=', $post['id']]]);
        if($result){
            return $this->returnMsg('修改成功',1);
        }else{
            return $this->returnMsg('修改成功');
        }
    }

    public function del()
    {
        $post = input();
        $ids = is_array($post['id']) ? implode(',', $post['id']) : $post['id'];
        if ($this->certorder->where("id IN(" . $ids . ")")->update(['is_del' => 1])) {
            return $this->returnMsg("删除成功", 1);
        } else {
            return $this->returnMsg("删除失败");
        }
    }


    //审核
    public function shenhecertorder()
    {
        $post = input();
        $errordesc = '';
        $shstatus = 3;
        if ($post['shstatus'] == 2) {
            if (empty($post['errordesc'])) {
                return $this->returnMsg("请输入失败原因");
            }
            $errordesc = $post['errordesc'];
            $shstatus = 2;
        }

        $updatedata['status'] = $shstatus;
        $updatedata['status_desc'] = $errordesc;

        $result = $this->certorder->where('id', $post['id'])->update($updatedata);
        if ($result) {

            return $this->returnMsg("操作成功", 1);
        } else {
            return $this->returnMsg("操作失败");
        }

    }


    //详情
    public function detail()
    {
        $post = input();
        $info = $this->certorder->with(['certdata','userprofile'])->append(['status_text'])->where('id', $post['id'])->find();
        $this->assign('info', $info);
        return $this->fetch('', '', false);
    }

}