<?php

namespace app\admin\validate;

use think\Validate;
use app\model;
use app\api\validate\BaseValidate;

class ArticleValidate extends BaseValidate
{

    protected $rule = [
        'title' => 'require',
        'cate_id' => 'require|checkarticle',
//        'thumb' => 'require',
    ];
    protected $message = [
        'title.require' => '文章标题不能为空',
        'cate_id.require' => '请选择分类',
        'cate_id.checkarticle' => '此分类是单页只能添加一篇文章'
//        'thumb.require' => '请上传图片',

    ];


    function checkarticle($value,$rule,$data)
    {

        $type = (new model\ArticleCategoryModel())::where('id', $value)->value('type');

        if ($type == 'page' && empty($data['id'])) {

            $count = (new model\ArticleModel())->where('cate_id',$value)->where('is_del',0)->count();

            if ($count > 0) {
                return false;
            }
        }
        return true;
    }

}