<?php

namespace app\api\controller\manage;

use app\api\middleware\Auth;
use app\api\validate\ProjectTagValidate;
use app\BaseController;
use app\model\ProjectTag as ProjectTagModel;
use think\Request;

class ProjectTag extends BaseController
{
    protected $middleware = [
        Auth::class,
    ];

    public function createProjectTag(Request $request)
    {
        $vo = (new ProjectTagValidate())->goCheck();
        if ($vo !== true) {
            return $vo;
        }
        $parm = $request->param();

        $parm['user_id'] = $request->userId;
        $result = ProjectTagModel::create($parm);

        return $this->returnMsg('操作成功', 1, $result);
    }

    //标签列表
    public function getProjectTagList(Request $request)
    {
        $where = ['is_del' => 0, 'user_id' => $request->userId];

        $list = ProjectTagModel::where($where)
            ->order('createtime desc')
            ->select()->toArray();

        return $this->returnMsg('success', 1, $list);
    }
}