<?php

namespace app\api\controller\cert;

use app\api\validate\CertValidate;
use app\BaseController;
use app\model\CertCategory;
use app\model\CertOrder;
use think\Request;
use app\model\Cert as CertModel;

class Cert extends BaseController
{

    //项目分类列表
    public function getCertCategoryList()
    {
        $list = (new CertCategory())->getCertCategoryList();

        return $this->returnMsg('success',1,$list);
    }

    //项目列表
    public function getCertList(Request $request)
    {
        $vo = (new CertValidate())->goCheck(['category_id','type']);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->param();

        $page = $request->param('page/d', 1);
        $pageSize = $request->param('pageSize/d', 10);

        $list = (new CertModel())->getCertList($data['category_id'],$page,$pageSize,$data['type']);

        return $this->returnMsg('success',1,$list);
    }

    //认证动态
    public function getLatestCertList(Request $request)
    {

        $page = $request->param('page/d', 1);
        $pageSize = $request->param('pageSize/d', 10);

        $list = (new CertOrder())->latestCertList($page,$pageSize);

        return $this->returnMsg('success',1,$list);
    }

    //详情
    public function getDetailCert(Request $request)
    {
        $vo = (new CertValidate())->goCheck(['cert_id']);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->param();

        $detail = CertModel::where('id',$data['cert_id'])
            ->append(['starttimetxt','endtimetxt'])
            ->find();

        return $this->returnMsg('success',1,$detail);

    }


}