<?php

namespace app\api\controller;

use app\api\validate\UserValidate;
use app\BaseController;
use app\Request;
use think\facade\Cache;
use tool\SendSms;

class Sms extends BaseController
{
    const TOKEN_PREFIX = 'sms_token:';


    public function sendSms(Request $request)
    {

        $vo = (new UserValidate())->goCheck(['mobile']);
        if ($vo !== true) {
            return $vo;
        }


        $data = $request->param();

        $code = str_pad(random_int(0, 9999), 4, '0', STR_PAD_LEFT);

//        halt($code);
        $SMS  = new SendSms();

        $res = $SMS->aliyun_send($data['mobile'], $code);


        return $this->returnMsg($res['msg'],$res['code']);

    }

}