<?php

namespace app\api\controller\manage;

use app\api\middleware\Auth;
use app\api\service\UtilService;
use app\api\validate\ShCourseValidate;
use app\BaseController;
use app\model\ShCourse as ShCourseModel;
use app\Request;

class ShCourse extends BaseController
{

    protected $middleware = [
        Auth::class,
    ];

    //机构课程列表
    public function getShCourseList(Request $request)
    {
        $parm = $request->param();
        $where = ['is_del' => 0, 'user_id' => $request->userId];
        $map = [];
        if (isset($parm['searchKeyWords']) && $parm['searchKeyWords']) {
            $map[] = ['title', 'like', '%' . $parm['searchKeyWords'] . '%'];
        }
        if (isset($parm['status']) && $parm['status']) {
            $map[] = ['status', '=', $parm['status']];
        }
        if (isset($parm['cate_id']) && $parm['cate_id']) {
            $map[] = ['cate_id', '=', $parm['cate_id']];
        }
        if (isset($parm['start_time']) && $parm['start_time'] && isset($parm['end_time']) && $parm['end_time']) {

            $start_time = strtotime($parm['start_time']);
            $end_time = strtotime($parm['end_time']);
            $map[] = ['createtime', '>=', $start_time];
            $map[] = ['createtime', '<=', $end_time];
        }

        $page = $request->param('page', 1);
        $pageSize = $request->param('pageSize', 10);
        $list = ShCourseModel::where($where)->where($map)
            ->field('id,title,createtime,thumb,tag_ids,price,status,is_sell,is_del,tvclick,click,cate_id,teacher_id')
            ->order('createtime desc')
            ->append(['thumbpath', 'cate_name', 'tag_title', 'teacher_name', 'status_text'])
            ->paginate([
                'page' => $page,
                'list_rows' => $pageSize
            ]);
        return $this->returnMsg('success', 1, $list);
    }

    //修改课程属性
    public function updatecourseinfo(Request $request)
    {
        $vo = (new ShCourseValidate())->goCheck(['course_id', 'updateField', 'updateValue']);
        if ($vo !== true) {
            return $vo;
        }
        $parm = $request->param();
        $where = ['id' => $parm['course_id'], 'user_id' => $request->userId];
        $result = ShCourseModel::where($where)->update([$parm['updateField'] => $parm['updateValue']]);
        event('Course', ['course_id' => $parm['course_id'], 'tasktype' => 'course', 'action' => 'shcourseupdate']); //同步数据
        return $this->returnMsg('操作成功', 1, $result);

    }

    //删除课程
    public function coursedelete(Request $request)
    {

        $vo = (new ShCourseValidate())->goCheck(['course_id']);
        if ($vo !== true) {
            return $vo;
        }
        $parm = $request->param();
        $where = ['id' => $parm['course_id'], 'user_id' => $request->userId];
        $result = ShCourseModel::where($where)->update(['is_del' => 1]);
        event('Course', ['course_id' => $parm['course_id'], 'tasktype' => 'course', 'action' => 'shcourseupdate']); //同步数据
        return $this->returnMsg('操作成功', 1, $result);
    }

    //添加课程
    public function createShCourse(Request $request)
    {
        $vo = (new ShCourseValidate())->goCheck(['title', 'cate_id', 'thumb', 'teacher_id', 'thumb', 'detailthumb', 'content']);
        if ($vo !== true) {
            return $vo;
        }
        $parm = $request->param();
        $parm['sn'] = UtilService::generateOrderNo($request->userId, 'K');
        $parm['createtime'] = time();
        $parm['user_id'] = $request->userId;
        $result = ShCourseModel::create($parm);
        return $this->returnMsg('操作成功', 1, $result);
    }

    //修改课程
    public function editShCourse(Request $request)
    {
        $vo = (new ShCourseValidate())->goCheck(['course_id', 'title', 'cate_id', 'thumb', 'teacher_id', 'thumb', 'detailthumb', 'content']);
        if ($vo !== true) {
            return $vo;
        }
        $parm = $request->param();
        $udpatedata = $parm;
        unset($udpatedata['course_id']);
        $udpatedata['updatetime'] = time();
        $udpatedata['status'] = 0; //修改为待提交
        $result = ShCourseModel::where(['user_id' => $request->userId, 'id' => $parm['course_id']])->update($udpatedata);
        return $this->returnMsg('操作成功', 1, $result);

    }



}