<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\admin\controller\course;

use app\admin\controller\AdminBase;
use app\job\Jobtask;
use app\model\ShCourse as ShCourseModel;
use think\App;
use think\facade\Db;
use app\model\CourseCategory as CourseCategoryModel;


/**
 * 后台主控制器
 */
class Course extends AdminBase
{

    protected $course;

    public function __construct(App $app)
    {
        parent::__construct($app);

        $this->course = new ShCourseModel();

    }

    // 课程列表
    public function index(string $do = '')
    {

        $limit = 10;
        if ($do == 'json') {

            $post = input();
            $post['limit'] = isset($post['limit']) ? $post['limit'] : $limit;
            $map[] = ['is_del', '=', 0];
            $map[] = ['status', '>', 0];
            if (isset($post['kw']) && !empty($post['kw'])) {
                $map[] = ['title', 'like', '%' . $post['kw'] . '%'];
            }
            if (isset($post['cate_id']) && !empty($post['cate_id'])) {
                $map[] = ['cate_id', '=', $post['cate_id']];
            }
            $list = $this->course->where($map)->append(['thumbpath', 'cate_name', 'teacher_name', 'status_text', 'tag_title', 'user_info', 'is_sell_text'])->order('createtime desc')->paginate($post['limit']);

            return $this->returnMsg($list);
        }
        $category = CourseCategoryModel::field('*,pid as parentid')->where('is_del', 0)->order('sort desc')->select()->toArray();
        $this->assign('category', json_encode($category));
        $this->assign('limit', $limit);
        return $this->fetch('', '', false);
    }

    //快速编辑
    public function editup()
    {

        $post = input();
        $this->course->update([$post['af'] => $post['av']], [['id', '=', $post['id']]]);
        return $this->returnMsg('修改成功');
    }


    public function del()
    {
        $post = input();
        $ids = is_array($post['id']) ? implode(',', $post['id']) : $post['id'];
        if ($this->course->where("id IN(" . $ids . ")")->update(['is_del' => 1])) {
            $course_id_arr = $this->course->where("id IN(" . $ids . ")")->column('id');
            $course_id_arr = array_unique($course_id_arr);
            foreach ($course_id_arr as $course_id) {
                event('Course', ['course_id' => $course_id, 'tasktype' => 'course', 'action' => 'shcourseupdate']);
            }

            return $this->returnMsg("删除成功", 1);
        } else {
            return $this->returnMsg("删除失败");
        }
    }


    //审核课程
    public function shenhecourse()
    {
        $post = input();
        $errordesc = '';
        $shstatus = 3;
        if ($post['shstatus'] == 2) {
            if (empty($post['errordesc'])) {
                return $this->returnMsg("请输入失败原因");
            }
            $errordesc = $post['errordesc'];
            $shstatus = 2;
        }

        $updatedata['status'] = $shstatus;
        $updatedata['sh_time'] = time();
        $updatedata['sh_error_desc'] = $errordesc;

        $result = $this->course->where('id', $post['id'])->update($updatedata);
        if ($result) {
            if ($post['shstatus'] == 1) {
                event('Course', ['course_id' => $post['id'], 'tasktype' => 'course', 'action' => 'shstatus']);
            }
            return $this->returnMsg("操作成功", 1);
        } else {
            return $this->returnMsg("操作失败");
        }

    }

    //课程详情
    public function detail()
    {
        $post = input();
        $info = $this->course->where('id', $post['id'])->find();
        $this->assign('info', $info);
        return $this->fetch('', '', false);
    }

}