<?php

namespace app\api\validate;

use app\model\Student;
use app\Request;
use think\Validate;
use think\model\concern\SoftDelete;

class StudentValidate extends BaseValidate
{

    protected $rule = [
        'realname' => 'require',
        'sex' => 'require',
        'age' => 'require|between:5,80',
        'idcard' => 'require|idCard',
        'mobile' => 'require|mobile|checkmobile',
        'xq' => 'require',
        'nj' => 'require',
        'bj' => 'require',
        'xh' => 'require',
        'student_id' => 'require',
        'birthday' => 'date',
    ];
    protected $message = [
        'realname.require' => '姓名不能为空',
        'sex.require' => '性别不能为空',
        'age.require' => '年龄不能为空',
//        'birthday.require' => '出生年月不能为空',
        'idcard.require' => '身份证不能为空',
        'idcard.idCard' => '身份证格式不对',
        'mobile.require' => '手机号不能为空',
        'mobile.mobile' => '手机号格式不对',
        'xq.require' => '校区不能为空',
        'nj.require' => '年纪不能为空',
        'bj.require' => '班级不能为空',
        'xh.require' => '学号不能为空',
        'mobile.checkmobile' => '手机号已存在',
        'student_id.require' => '学生id不能为空',
        'birthday.date' => '日期格式不对'
    ];

    protected function checkmobile($value, $rule, $data = [])
    {
        $result = Student::where(['mobile' => $value])->count();
        if ($result) return false;

        return true;
    }

}