<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\admin\controller\cert;

use app\admin\controller\AdminBase;
use app\model\CertFile as CertFileModel;
use app\admin\validate\CertFileValidate;
use think\App;

/**
 * 后台主控制器
 */
class CertFile extends AdminBase
{

    protected $certfile;

    public function __construct(App $app)
    {
        parent::__construct($app);

        $this->certfile = new CertFileModel();

    }

    // 列表
    public function index(string $do = '')
    {


    }

    //快速编辑
    public function editup()
    {

        $post = input();
        $result = $this->certfile->update([$post['af'] => $post['av']], [['id', '=', $post['id']]]);
        if ($result) {
            return $this->returnMsg('修改成功', 1);
        } else {
            return $this->returnMsg('修改成功');
        }
    }

    public function del()
    {
        $post = input();
        $ids = is_array($post['id']) ? implode(',', $post['id']) : $post['id'];
        if ($this->certfile->where("id IN(" . $ids . ")")->update(['is_del' => 1])) {
            return $this->returnMsg("删除成功", 1);
        } else {
            return $this->returnMsg("删除失败");
        }
    }


    //编辑新增
    public function edit()
    {
        $post = input();
        if ($this->request->isPost()) {
            $check = (new CertFileValidate())->goCheck();
            if ($check !== true) {
                return $check;
            }
            try {

                $file = array_shift($post['upload']);
                $data['file_id'] = $file['fileid'];
                $certfileinfo = $this->certfile->where('cert_order_id', $post['cert_order_id'])->find();
                if ($certfileinfo) {
                    $msg = "编辑成功";
                    $certfileinfo->save($data);
                } else {
                    $msg = "添加成功";
                    $data['cert_order_id'] = $post['cert_order_id'];
                    $this->certfile->create($data);
                }

            } catch (\Exception $e) {

                return $this->returnMsg($e->getMessage(), 0);
            }
            return $this->returnMsg($msg, 1);

        }
        $certfileinfo = $this->certfile->where('cert_order_id', $post['cert_order_id'])->with(['certfile'])->find();
        $this->assign('certfileinfo', $certfileinfo);
        $this->assign('cert_order_id', $post['cert_order_id']);
        return $this->fetch('', '', false);
    }


    //详情
    public function detail()
    {
        $post = input();
        $info = $this->certfile->with(['certdata', 'userprofile'])->append(['status_text'])->where('id', $post['id'])->find();
        $this->assign('info', $info);
        return $this->fetch('', '', false);
    }

}