<?php

namespace app\model\project;

use think\Model;
use function Symfony\Component\Translation\t;

class UserSmrz extends Model
{

    protected $autoWriteTimestamp = true;

    protected $createTime = 'create_time';
    //用户信息
    public function getuserdata()
    {
        return $this->belongsTo(User::class, 'user_id')
            ->field('username,mobile,id');
    }


    public function getStatusTextAttr($value, $data)
    {
        switch ($data['status']) {
            case 1:
                $statustxt = '审核失败';
                break;
            case 2:
                $statustxt = '审核成功';
                break;
            default:
                $statustxt = '待审核';
        }

        return $statustxt;
    }

    public function getIdcardQurlAttr($value, $data){

        return get_upload_file($data['idcard_q']);
    }

    public function getIdcardHurlAttr($value, $data){

        return get_upload_file($data['idcard_h']);
    }

}