<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\admin\controller\order;

use app\admin\controller\AdminBase;
use app\event\PhpOffice;
use think\App;
use think\facade\Db;
use app\model\Payment as PaymentModel;


/**
 * 后台主控制器
 */
class Payment extends AdminBase
{

    protected $payment;

    public function __construct(App $app)
    {
        parent::__construct($app);

        $this->payment = new PaymentModel();

    }

    // 列表
    public function index(string $do = '')
    {

        $limit = 10;
        if ($do == 'json') {

            $post = input();
            $post['limit'] = isset($post['limit']) ? $post['limit'] : $limit;
            $map = [];
            $hasmap = [];
            if (isset($post['kw']) && !empty($post['kw'])) {
                $map[] = ['order_no', 'like', '%' . $post['kw'] . '%'];
            }
            if (isset($post['user']) && !empty($post['user'])) {
                $hasmap[] = ['username|mobile', 'like', '%' . $post['user'] . '%'];
            }
            if (isset($post['pay_status']) && $post['pay_status'] > -1) {
                $map[] = ['pay_status', '=', $post['pay_status']];
            }
            $list = $this->payment->where($map)->hasWhere('getuserdata', $hasmap)->with(['getuserdata'])->append(['pay_status_text', 'pay_method_text', 'pay_time_text', 'order_name'])->order('createtime desc')->paginate($post['limit']);
            return $this->returnMsg($list);
        }

        $this->assign('limit', $limit);
        return $this->fetch('', '', false);
    }

    //快速编辑
    public function editup()
    {

        $post = input();
        $result = $this->payment->update([$post['af'] => $post['av']], [['id', '=', $post['id']]]);
        if ($result) {
            return $this->returnMsg('修改成功', 1);
        } else {
            return $this->returnMsg('修改失败');
        }
    }

    public function del()
    {
        $post = input();
        $ids = is_array($post['id']) ? implode(',', $post['id']) : $post['id'];
        if ($this->payment->where("id IN(" . $ids . ")")->update(['is_del' => 1])) {
            return $this->returnMsg("删除成功", 1);
        } else {
            return $this->returnMsg("删除失败");
        }
    }

    //导出excel
    public function excelpayment()
    {
        $post = input();
        $map = [];
        $hasmap = [];
        if (isset($post['kw']) && !empty($post['kw'])) {
            $map[] = ['order_no', 'like', '%' . $post['kw'] . '%'];
        }
        if (isset($post['user']) && !empty($post['user'])) {
            $hasmap[] = ['username|mobile', 'like', '%' . $post['user'] . '%'];
        }
        if (isset($post['pay_status']) && $post['pay_status'] > -1) {
            $map[] = ['pay_status', '=', $post['pay_status']];
        }

        try {
            $list = $this->payment->where($map)->hasWhere('getuserdata', $hasmap)->with(['getuserdata'])->append(['pay_status_text', 'pay_method_text', 'pay_time_text', 'order_name'])->order('createtime desc')->select()->toArray();
            if (empty($list)) {
                throw new \Exception('没有数据');
            }
            $exceldata[] = ['支付单号', '用户名', '用户手机', '支付详细', '支付金额', '支付状态', '支付类型', '支付时间', '创建时间'];
            foreach ($list as $k => $v) {

                $exceldata[] = [
                    $v['order_no'],
                    $v['getuserdata']['username'],
                    $v['getuserdata']['mobile'],
                    $v['order_name'],
                    $v['pay_amount'],

                    $v['pay_status_text'],
                    $v['pay_method_text'],
                    $v['pay_time_text'],
                    $v['createtime']
                ];
            }
            $excelid = PhpOffice::exportexcel($exceldata, '订单导出');
            $data['url'] = '/admin/order.payment/downloadfile?excel=1&fileid=' . $excelid;
            return $this->returnMsg('success', 1, $data);
        } catch (\Exception $e) {
            return $this->returnMsg($e->getMessage());
        }

    }

}