<?php

namespace app\api\controller\mine;

use app\api\controller\PayController;
use app\api\middleware\Auth;
use app\api\service\UserService;
use app\api\service\UtilService;
use app\api\validate\CertValidate;
use app\api\validate\CourseValidate;
use app\api\validate\UserValidate;
use app\BaseController;
use app\model\CertOrder;
use app\model\CertOrderAddress;
use app\model\Course as CourseModel;
use app\model\Payment;
use app\model\project\Mail;
use app\model\project\UserAccount;
use app\model\project\UserMoneyLog;
use app\model\project\UserSmrz;
use app\model\project\UserWithdrawal;
use app\Request;
use app\model\project\User as UserModel;
use think\facade\Db;
use think\facade\Validate;

class User extends BaseController
{

    protected $middleware = [
        Auth::class,
    ];

    public function getUserInfo(Request $request)
    {

        $vo = (new UserValidate())->goCheck(['token']);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->header();

        $user = UserService::getUserInfo($data['token']);

        if (!$user) {
            return $this->returnMsg('登录失效', 201);
        }


        $info_status = '';
        if ($user['role'] == 2) {
            $info_status = Db::name('business')->where('user_id', $user['id'])->value('status');
        } elseif ($user['role'] == 3) {
            $info_status = Db::name('school')->where('user_id', $user['id'])->value('status');
        }
        $user['info_status'] = $info_status;

        if ($user['role'] == 1) {
            // 获取当前月份和上个月的起始和结束时间戳
            $currentMonthStart = strtotime(date('Y-m-01 00:00:00'));
            $currentMonthEnd = strtotime(date('Y-m-t 23:59:59'));
            $lastMonthStart = strtotime(date('Y-m-01 00:00:00', strtotime('-1 month')));
            $lastMonthEnd = strtotime(date('Y-m-t 23:59:59', strtotime('-1 month')));

            // 本月收入 (类型为0-项目结算和2-后台手动增加)
            $currentMonthIncome = UserMoneyLog::where('user_id', $user['id'])
                ->whereIn('type', [0, 2])
                ->where('money_type', 0)
                ->whereBetween('createtime', [$currentMonthStart, $currentMonthEnd])
                ->sum('money');
            $user['financial']['current_month_income'] = number_format($currentMonthIncome, 2);
            // 本月支出 (类型为1-提现)
            $currentMonthExpense = abs(UserMoneyLog::where('user_id', $user['id'])
                ->whereIn('type', [1])
                ->where('money_type', 0)
                ->whereBetween('createtime', [$currentMonthStart, $currentMonthEnd])
                ->sum('money'));
            $user['financial']['current_month_expense'] = number_format($currentMonthExpense, 2);

            // 上月收入
            $lastMonthIncome = UserMoneyLog::where('user_id', $user['id'])
                ->whereIn('type', [0, 2])
                ->where('money_type', 0)
                ->whereBetween('createtime', [$lastMonthStart, $lastMonthEnd])
                ->sum('money');
            $user['financial']['lastMonthIncome'] = number_format($lastMonthIncome, 2);

            // 上月支出
            $lastMonthExpense = abs(UserMoneyLog::where('user_id', $user['id'])
                ->whereIn('type', [1])
                ->where('money_type', 0)
                ->whereBetween('createtime', [$lastMonthStart, $lastMonthEnd])
                ->sum('money'));
            $user['financial']['lastMonthExpense'] = number_format($lastMonthExpense, 2);


            // 计算较上月百分比
            $user['financial']['income_change_percent'] = $lastMonthIncome != 0
                ? number_format(($currentMonthIncome - $lastMonthIncome) / $lastMonthIncome * 100, 2)
                : ($currentMonthIncome != 0 ? '100.00' : '0.00');

            $user['financial']['expense_change_percent'] = $lastMonthExpense != 0
                ? number_format(($currentMonthExpense - $lastMonthExpense) / $lastMonthExpense * 100, 2)
                : ($currentMonthExpense != 0 ? '100.00' : '0.00');

        }

        return $this->returnMsg('操作成功', 1, $user);
    }

    public function updateUserInfo(Request $request)
    {
        $vo = (new UserValidate())->goCheck(['updateField', 'updateValue']);
        if ($vo !== true) {
            return $vo;
        }

        $data = $request->param();

        $res = UserService::updateUserInfo($data['updateField'], $data['updateValue']);

        return $this->returnMsg('操作成功', 1, $res);
    }

    public function bindZfb(Request $request)
    {
        $vo = (new UserValidate())->goCheck(['zfb']);
        if ($vo !== true) {
            return $vo;
        }

//        if (UserAccount::where(['user_id' => $request->userId, 'is_del' => 0])->count()) {
//            return $this->returnMsg('请勿重复提交');
//        }
        $data = $request->param();
        $zfbinfo = UserAccount::where(['user_id' => $request->userId, 'is_del' => 0])->find();
        $data['type'] = 0;
        $data['account'] = $data['zfb'];
        $data['user_id'] = $request->userId;
        unset($data['zfb']);
        if ($zfbinfo) {
            $res = UserAccount::where('user_id', $request->userId)->update($data);
        } else {
            $res = UserAccount::create($data);
        }

        return $this->returnMsg('操作成功', 1, $res);

    }

    public function editMobile(Request $request)
    {
        $vo = (new UserValidate())->goCheck(['mobile', 'code']);
        if ($vo !== true) {
            return $vo;
        }

        $data = $request->param();

        //check sms
        $checkSmsCode = UtilService::checkSmsCode($data['mobile'], $data['code']);
        if (!$checkSmsCode) {
            return $this->returnMsg('验证码错误');
        }

        $is_exit = userModel::where(['mobile' => $data['mobile']])->where('is_del', 0)->count();
        if ($is_exit) {
            return $this->returnMsg('手机号已存在');
        }

        $res = UserService::updateUserInfo('mobile', $data['mobile']);
        return $this->returnMsg('操作成功', 1, $res);

    }

    //第一步验证手机
    public function editMobileone(Request $request)
    {
        $vo = (new UserValidate())->goCheck(['code']);
        if ($vo !== true) {
            return $vo;
        }

        $data = $request->param();
        $userInfo = UserModel::where(['id' => $request->userId, 'is_del' => 0])->field('id,mobile')->find();
        //check sms
        $checkSmsCode = UtilService::checkSmsCode($userInfo['mobile'], $data['code']);
        if (!$checkSmsCode) {
            return $this->returnMsg('验证码错误');
        }
        return $this->returnMsg('操作成功', 1);

    }

    public function realUser(Request $request)
    {
        $vo = (new UserValidate())->goCheck(['realname', 'idcard', 'idcard_q', 'idcard_h']);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->param();
        $smrzinfo = UserSmrz::where(['user_id' => $request->userId])->where('is_del', 0)->find();
        if ($smrzinfo) {
            if ($smrzinfo['status'] == 2) {
                return $this->returnMsg('已认证');
            }
            $data['status'] = 2;
            $res = UserSmrz::update($data, ['user_id' => $request->userId]);
        } else {

            $data['user_id'] = $request->userId;
            $data['status'] = 2;
            $res = UserSmrz::create($data);
        }

//        if (UserSmrz::where(['user_id' => $request->userId, 'is_del' => 0, 'status' => 2])->count()) {
//            return $this->returnMsg('请勿重复提交');
//        }
//
//        $data = $request->param();
//
//        $data['user_id'] = $request->userId;
//
//        $res = UserSmrz::create($data);

        return $this->returnMsg('操作成功', 1, $res);

    }

    public function withdrawal(Request $request)
    {
        $vo = (new UserValidate())->goCheck(['amount', 'txType']);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->param();

        $userId = $request->userId;

        $userInfo = UserModel::where(['id' => $userId, 'is_del' => 0])->find();
        if ($userInfo['money'] < $data['amount']) {
            return $this->returnMsg('余额不足');
        }

        $smrzstatus = UserSmrz::where(['user_id' => $request->userId])->value('status');
        if ($smrzstatus != 2) {
            return $this->returnMsg('请先实名认证');
        }

        $count = UserMoneyLog::where(['user_id' => $userId, 'type' => 1])
            ->whereBetween('createtime', [strtotime('today'), strtotime('tomorrow') - 1])
            ->count();
        if ($count) {
            return $this->returnMsg('每天只能提现一次');
        }

        $UserWithdrawalModel = new UserWithdrawal();

        $sum = $UserWithdrawalModel->where(['user_id' => $userId])
            ->whereBetween('createtime', [strtotime('today'), strtotime('tomorrow') - 1])
            ->sum('tx_money');

        if ($sum > 10000) {
            return $this->returnMsg('超出每日限额');
        }

        $userAccount = UserAccount::where(['user_id' => $userId, 'is_del' => 0, 'type' => $data['txType']])->find();

        $commission = vconfig('commission') ?: 0;
//        halt($commission);

        $res = $UserWithdrawalModel->applyWithdrawal($userId, $data['amount'], $data['txType'], $userAccount['account'], $userInfo['realname'], $commission, $userInfo['money']);

        if (!$res['status']) {
            return $this->returnMsg($res['msg']);
        }

        return $this->returnMsg('success', 1);

    }

    //站内信
    public function getUserMailList(Request $request)
    {
        $page = $request->param('page/d', 1);
        $pageSize = $request->param('pageSize/d', 10);

        $list = Mail::where('user_id', $request->userId)->order('createtime', 'desc')
            ->paginate([
                'page' => $page,
                'list_rows' => $pageSize
            ]);

        return $this->returnMsg('success', 1, $list);
    }

    public function buyCourse(\think\Request $request)
    {

        $vo = (new CourseValidate())->goCheck(['course_id']);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->param();
        $userId = $request->userId;


        $course = CourseModel::where([
            'id' => $data['course_id'],
            'status' => 3,
            'is_sell' => 1,
            'is_del' => 0
        ])->find();

        if (!$course) {
            return $this->returnMsg('课程不存在');
        }
        if ($course['price'] <= 0) {
            return $this->returnMsg('免费课程无需购买');
        }

        // 验证购买状态（1表示视频类型）
        if (UtilService::checkPurchase($userId, $data['course_id'], 1)) {
            return $this->returnMsg('请勿重复购买');
        }
        $params = [
            'order_id' => $data['course_id'],
            'order_type' => 1,
            'pay_method' => $data['pay_method'],
            'amount' => $course['price'],
            'user_id' => $userId,
        ];

        $payController = new PayController();

        return $payController->create($params);

    }

    //证书购买
    public function buyCert(\think\Request $request)
    {

        $vo = (new CertValidate())->goCheck(['cert_id']);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->param();
        $userId = $request->userId;


        $course = \app\model\Cert::where([
            'id' => $data['cert_id'],
            'is_sell' => 1,
            'is_del' => 0
        ])->find();

        if (!$course) {
            return $this->returnMsg('证书不存在');
        }
//        if ($course['price']<=0)
//        {
//            return $this->returnMsg('免费证书无需购买');
//        }

        $courseOrder = CertOrder::where(['status' => 0, 'user_id' => $userId, 'cert_id' => $course['id']])->count();
        if (!$courseOrder) {
            return $this->returnMsg('请先报名');
        }

        // 验证购买状态（2表示证书类型）
        if (UtilService::checkPurchase($userId, $data['cert_id'], 2)) {
            return $this->returnMsg('请勿重复购买');
        }
        $params = [
            'order_id' => $data['cert_id'],
            'order_type' => 2,
            'pay_method' => $data['pay_method'],
            'amount' => $course['price'],
            'user_id' => $userId,
        ];

        $payController = new PayController();

        return $payController->create($params);

    }

    public function editPassword(Request $request)
    {
        $vo = (new UserValidate())->goCheck(['confirm_password', 'password', 'old_password']);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->param();
        $userId = $request->userId;


        $user = userModel::where('id', $userId)->find();

        if (!$user) {
            return $this->returnMsg('用户不存在', 0);
        }

        $data['old_password'] = md5($data['old_password'] . $user['salt']);
        if ($data['old_password'] != $user['password']) {
            return $this->returnMsg('旧密码密码不正确');
        }


        userModel::where('id', $userId)->update(['password' => md5($data['password'] . $user['salt'])]);

        return $this->returnMsg('success', 1);

    }

    //用户订单
    public function getOrderList(Request $request)
    {
        $page = $request->param('page/d', 1);
        $pageSize = $request->param('pageSize/d', 10);

        $where = ['p.user_id' => $request->userId];

        // 搜索条件
        $order_no = $request->param('order_no', '');
        if ($order_no) {
            $where['p.order_no'] = ['like', "%{$order_no}%"];
        }

        $pay_no = $request->param('pay_no', '');
        if ($pay_no) {
            $where['p.pay_no'] = ['like', "%{$pay_no}%"];
        }

        $keyword = $request->param('keyword', '');

        $query = Payment::alias('p')
            ->where($where)
            ->leftJoin('course c', "p.order_id = c.id AND p.order_type = 1")
            ->leftJoin('cert ce', "p.order_id = ce.id AND p.order_type = 2")
            ->field([
                'p.order_no',
                'p.pay_no',
                'p.createtime',
                'p.pay_channel',
                'p.pay_method',
                'p.order_price',
                'p.pay_amount',
                'p.pay_status',
                'p.order_type',
                'p.pay_time',
                'IF(p.order_type=1, c.title, ce.title) as title',
                'IF(p.order_type=1, c.price, ce.price) as price'
            ]);

        if ($keyword) {
            $query = $query->where('c.title|ce.title', 'like', "%{$keyword}%");
        }

        $list = $query->order('p.createtime', 'desc')
            ->paginate([
                'page' => $page,
                'list_rows' => $pageSize
            ]);

        // foreach ($list as &$item) {
        //     $item['order_type_text'] = $item['order_type'] == 1 ? '课程' : '证书';
        //     $item['pay_method_text'] = $item['pay_method'] == 1 ? '支付宝' : '微信';
        // }
        // unset($item);

        return $this->returnMsg('success', 1, $list);
    }


    //证书添加收获地址
    public function savecertaddress(Request $request)
    {
        $post = $request->param();
        $validate = Validate::rule([
            'cert_order_id' => 'require',
            'nickname' => 'require',
            'mobile' => 'require|mobile',
            'province' => 'require',
            'city' => 'require',
            'area' => 'require',
            'address' => 'require',
        ])->message([
            'cert_order_id.require' => '证书id不能为空',
            'nickname.require' => '收货人不能为空',
            'mobile.require' => '收货人联系方式不能为空',
            'mobile.mobile' => '收货人联系方式错误',
            'province.require' => '请选择省市区',
            'city.require' => '请选择省市区',
            'area.require' => '请选择省市区',
            'address.require' => '请输入详细地址',
        ]);

        if (!$validate->check($post)) {
            return $this->returnMsg($validate->getError(), 0);
        }
        $data = $request->only(['cert_order_id', 'nickname', 'mobile', 'province', 'city', 'area', 'address']);
        $data['user_id'] = $request->userId;
        $data['detail_address'] = get_area_name($data['province']) . ' ' . get_area_name($data['city']) . ' ' . get_area_name($data['area']) . ' ' . $data['address'];
        $info = CertOrderAddress::where(['cert_order_id' => $post['cert_order_id']])->find();
        if ($info) {
            $res = CertOrderAddress::where(['cert_order_id' => $post['cert_order_id']])->update($data);
        } else {
            $res = CertOrderAddress::create($data);
        }
        return $this->returnMsg('添加成功', 1, $res);
    }
}