<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\admin\controller;

use app\job\Jobtask;
use app\model\system\SystemDict as Dict;
use app\model\system\SystemMenus as Menus;
use app\model\system\SystemCategory as Category;
use think\facade\Db;
use think\facade\Queue;
use Carbon\Carbon;

/**
 * 后台主控制器
 */
class Index extends AdminBase
{
    /**
     * 后台首页
     * @return mixed
     */
    public function index()
    {

        $this->assign([
            "appMap" => $this->appMap,
            "tokenName" => $this->tokenName
        ]);
        return $this->fetch('', '', false);
    }

    public function welcome()
    {

        return $this->fetch();
    }


    /**
     * 后台主面板
     * @return mixed
     */

    public function main()
    {
        if ($this->manUser['userid'] > 1 && !in_array($this->routeUri, $this->manUser['actions'])) {
            $this->assign('user', $this->manUser);
            return $this->fetch('welcome');
        }

        $business_dsh_count = Db::name('business')->where(['is_del' => '0', 'status' => 0])->count(); //企业资料待审核
        $school_dsh_count = Db::name('school')->where(['is_del' => '0', 'status' => 0])->count(); //学校资料待审核
        $course_dsh_count = Db::name('sh_course')->where(['is_del' => '0', 'status' => 1])->count(); //课程待审核
        $project_dsh_count = Db::name('project')->where(['sh_status' => 0])->where('deletetime', 'NUll')->count(); //项目待审核
        $tixian_dsh_count = Db::name('user_withdrawal')->where(['sh_status' => 0])->where('deletetime', 'NUll')->count(); //提现待审核
        $tixian_dk_dsh_count = Db::name('user_withdrawal')->where(['sh_status' => 2, 'dk_status' => 0])->where('deletetime', 'NUll')->count(); //打款待审核

        $data['business_dsh_count'] = $business_dsh_count ?? 0;
        $data['school_dsh_count'] = $school_dsh_count ?? 0;
        $data['course_dsh_count'] = $course_dsh_count ?? 0;
        $data['project_dsh_count'] = $project_dsh_count ?? 0;
        $data['tixian_dsh_count'] = $tixian_dsh_count ?? 0;
        $data['tixian_dk_dsh_count'] = $tixian_dk_dsh_count ?? 0;


        $visitors_sum = Db::name('webiste')->where('id', 1)->value('unique_visitors'); //总访问量
        $todayStart = Carbon::today()->timestamp;// 今日开始时间（00:00:00）
        $todayEnd = Carbon::today()->endOfDay()->timestamp; // 今日结束时间（23:59:59）
        $map[] = ['logtime', '>=', $todayStart];
        $map[] = ['logtime', '<=', $todayEnd];
        $day_visitors = Db::name('webiste_log')->where($map)->count(); //今日访问量

        $payment_sum_money = Db::name('payment')->where('pay_status', 1)->sum('pay_amount'); //总销售金额
        $monthStart = Carbon::now()->startOfMonth()->timestamp; // 本月1号 00:00:00
        $monthEnd = Carbon::now()->endOfMonth()->timestamp;     // 本月最后一天 23:59:59
        $map = [];
        $map[] = ['pay_time', '>=', $monthStart];
        $map[] = ['pay_time', '<=', $monthEnd];
        $map[] = ['pay_status', '=', 1];
        $month_sum_money = Db::name('payment')->where($map)->sum('pay_amount'); //月销售金额

        $payment_sum_count = Db::name('payment')->where('pay_status', 1)->count(); //订单量
        $map = [];
        $map[] = ['pay_time', '>=', $monthStart];
        $map[] = ['pay_time', '<=', $monthEnd];
        $map[] = ['pay_status', '=', 1];
        $month_payment_count = Db::name('payment')->where($map)->count(); //月订单量

        $user_sum_count = Db::name('user')->where('is_del', 0)->count(); //总用户数量
        $map = [];
        $map[] = ['reg_time', '>=', $todayStart];
        $map[] = ['reg_time', '<=', $todayEnd];
        $user_day_count = Db::name('user')->where($map)->count(); //今日新增用户量

        $course_sum_tvclick_count = Db::name('course')->where('is_del', 0)->sum('tvclick'); //课程总播放量
        $course_sum_count = Db::name('course')->where('is_del', 0)->count(); //课程数量

        $data['visitors_sum'] = $visitors_sum;
        $data['day_visitors'] = $day_visitors;
        $data['payment_sum_money'] = $payment_sum_money;
        $data['month_sum_money'] = $month_sum_money;
        $data['payment_sum_count'] = $payment_sum_count;
        $data['month_payment_count'] = $month_payment_count;
        $data['user_sum_count'] = $user_sum_count;
        $data['user_day_count'] = $user_day_count;
        $data['course_sum_tvclick_count'] = $course_sum_tvclick_count;
        $data['course_sum_count'] = $course_sum_count;

        //统计图
        // 如果需要每天的起始和结束时间戳
        $recent15DaysRanges = [];
        for ($i = 0; $i < 15; $i++) {
            $day = Carbon::now()->subDays($i);
            $recent15DaysRanges[] = [
                'start' => $day->startOfDay()->timestamp,
                'end' => $day->endOfDay()->timestamp,
                'date' => date('m-d', $day->timestamp)
            ];
        }
        $add_user_category = array_column($recent15DaysRanges, 'date');
        $add_user_series = [];
        foreach ($recent15DaysRanges as $k => $v) {

            $map = [];
            $map[] = ['reg_time', '>=', $v['start']];
            $map[] = ['reg_time', '<=', $v['end']];
            $map[] = ['is_del', '=', 0];
            $add_user_series[] = Db::name('user')->where($map)->count(); //新增用户量

        }
        $data['add_user_category'] = $add_user_category ? json_encode($add_user_category) : [];
        $data['add_user_series'] = $add_user_series ? json_encode($add_user_series) : [];

        //销售金额
        $add_payment_category = $add_user_category;
        $add_payment_series = [];
        foreach ($recent15DaysRanges as $k => $v) {

            $map = [];
            $map[] = ['pay_time', '>=', $v['start']];
            $map[] = ['pay_time', '<=', $v['end']];
            $map[] = ['pay_status', '=', 1];
            $add_payment_series[] = Db::name('payment')->where($map)->sum('pay_amount'); //销售金额
        }
        $data['add_payment_category'] = $add_payment_category ? json_encode($add_payment_category) : [];
        $data['add_payment_series'] = $add_payment_series ? json_encode($add_payment_series) : [];
        $this->assign('data', $data);
        return $this->fetch();
    }

    //待审核数据 提示
    public function dshtishi()
    {
        $business_dsh_count = Db::name('business')->where(['is_del' => '0', 'status' => 0])->count(); //企业资料待审核
        $school_dsh_count = Db::name('school')->where(['is_del' => '0', 'status' => 0])->count(); //学校资料待审核
        $course_dsh_count = Db::name('sh_course')->where(['is_del' => '0', 'status' => 1])->count(); //课程待审核
        $project_dsh_count = Db::name('project')->where(['sh_status' => 0])->where('deletetime', 'NUll')->count(); //项目待审核
        $tixian_dsh_count = Db::name('user_withdrawal')->where(['sh_status' => 0])->where('deletetime', 'NUll')->count(); //提现待审核
        $tixian_dk_dsh_count = Db::name('user_withdrawal')->where(['sh_status' => 2, 'dk_status' => 0])->where('deletetime', 'NUll')->count(); //打款待审核
        $dsh_sum_count = $business_dsh_count + $school_dsh_count + $course_dsh_count + $tixian_dsh_count + $tixian_dk_dsh_count + $project_dsh_count;
        return $this->returnMsg('success', 1, ['dsh_sum_count' => $dsh_sum_count]);
    }

    public function main11111111111()
    {

//        Queue::push(Jobtask::class, '','coursetask'); // 推送到队列的任务类及其数据参数
        if ($this->request->isPost()) {
            return $this->returnMsg('登录成功！', 1);
        }


        $data['type'] = 'imagewt';
        $data['name'] = 'headimgwt';
        $this->assign('data', $data);

        $data2['type'] = 'imageswt';
        $data2['name'] = 'headimgwt2';
        $data2['value'] = '';
        $this->assign('data2', $data2);

        $data3['type'] = 'imageswt';
        $data3['name'] = 'headimgwts2';
        $data3['value'] = '';
        $this->assign('data3', $data3);

        $data4['type'] = 'upfilewt';
        $data4['name'] = 'filename';
        $data4['value'] = '';
        $this->assign('data4', $data4);
        return $this->fetch();
    }

    /**
     * 获取左侧菜单和用户信息
     * @param int $do 是否更新字典缓存0否1是
     * @return json
     */
    public function json(int $do = 0)
    {
        $arr = [];
        $cat = Category::catList([['state', '=', 1], ['type', '=', '01']], 0, 'title,icon,catid'); // 获取菜单分类
        $data = Menus::getMenus(array_intersect_key($this->manUser, ['userid' => "", 'role_menuid' => ""])); // 获取拥有的菜单数据
        $rs = [
            'menus' => $cat ? ['cat' => $cat, 'menus' => $data['menus']] : $data['menus'],
            'user' => $this->manUser + ['roles' => $data['roles']] + ['rolem' => \app\model\system\SystemRoles::where("state = 1 AND roleid IN(" . $this->manUser['roleids'] . ")")->column("roleid id,role_name name")] + ['dict' => Dict::cache((int)$do)]
        ];
        unset($rs['user']['password'], $rs['user']['passsalt']);
        return json($rs);
    }

    /**
     * 清空缓存
     * @return json
     */
    public function clear()
    {
        \think\facade\Cache::clear();
        return $this->returnMsg("清理缓存成功!");
    }

    /**
     * 查询IP所在地区
     * @return mixed
     */
    public function ip()
    {
        $url = 'https://whois.pconline.com.cn/ipJson.jsp?callback=' . input('callback') . '&ip=' . input('ip');
        $cont = trim(file_get_contents($url));
        $cont = iconv("gb2312", "utf-8//IGNORE", $cont);
        return $cont;
    }

}