<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\admin\controller\caiwu;

use app\admin\controller\AdminBase;
use think\App;
use think\facade\Db;
use app\model\project\UserMoneyLog as UserMoneyLogModel;
use app\model\project\User;

/**
 * 后台主控制器
 */
class UserMoneyLog extends AdminBase
{

    protected $usermoneylog;

    public function __construct(App $app)
    {
        parent::__construct($app);

        $this->usermoneylog = new UserMoneyLogModel();
    }

    // 列表
    public function index(string $do = '')
    {

        $limit = 10;
        if ($do == 'json') {

            $post = input();
            $post['limit'] = isset($post['limit']) ? $post['limit'] : $limit;
            $map = [];
            $hasmap = [];
            if (isset($post['kw']) && !empty($post['kw'])) {
                $map[] = ['content', 'like', '%' . $post['kw'] . '%'];
            }
            if (isset($post['type']) && $post['type'] > -1) {
                $map[] = ['type', '=', $post['type']];
            }
            if (isset($post['user_id']) && !empty($post['user_id'])) {
                $map[] = ['user_id', '=', $post['user_id']];
            }
            if (isset($post['user']) && !empty($post['user'])) {
                $hasmap[] = ['username|mobile', 'like', '%' . $post['user'] . '%'];
            }
            $list = $this->usermoneylog->where($map)->hasWhere('getuserdata', $hasmap)->with(['getuserdata'])->append(['type_text'])->order('createtime desc')->paginate($post['limit']);
            return $this->returnMsg($list);
        }
        $this->assign('limit', $limit);
        return $this->fetch('', '', false);
    }


    public function del()
    {
        $post = input();
        $ids = is_array($post['id']) ? implode(',', $post['id']) : $post['id'];
        if ($this->usermoneylog->destroy([$ids])) {
            return $this->returnMsg("删除成功", 1);
        } else {
            return $this->returnMsg("删除失败");
        }
    }



}