<?php

namespace app\api\controller;

use app\api\middleware\Auth;
use app\api\service\UserService;
use app\api\service\UtilService;
use app\api\validate\CourseValidate;
use app\BaseController;
use app\model\Payment;
use think\Facade\Request;
use app\api\service\CourseProgressService;
use app\model\Course as CourseModel;

class CourseProgress extends BaseController
{

    protected $middleware = [
        Auth::class,
    ];



    /**
     * 上报学习进度API
     */
    public function reportProgress()
    {
        $vo = (new CourseValidate())->goCheck(['course_id','current_time','class_id']);
        if ($vo !== true) {
            return $vo;
        }

        $data = Request::only(['course_id', 'class_id', 'current_time']);
        $userId = $this->request->userId;

        $result = CourseProgressService::updateProgress(
            $userId,
            $data['course_id'],
            $data['class_id'],
            $data['current_time'],
        );

        if (!$result) {
            return $this->returnMsg('视频不存在',0);
        }

        return $this->returnMsg('操作成功',1,$result);

    }

    /**
     * 获取课程进度API
     */
    public function getProgress()
    {

        $userId = $this->request->userId;
        $page = Request::param('page', 1);
        $pageSize = Request::param('pageSize', 10);
        $type = Request::param('type', 0); // 0:全部 1:付费 2:免费

        $progress = CourseProgressService::getUserAllCoursesProgress($userId, $page, $pageSize, $type);

        return $this->returnMsg('操作成功',1,$progress);
    }

    /**
     * 获取最后学习位置API
     */
    public function getLastLearn()
    {
        $vo = (new CourseValidate())->goCheck(['course_id']);
        if ($vo !== true) {
            return $vo;
        }

        $userId = $this->request->userId;

        $data = Request::only(['course_id']);
        $lastLearn = CourseProgressService::getLearnedClasses($userId, $data['course_id']);

        return $this->returnMsg('操作成功',1,$lastLearn);

    }

    /**添加用户作业
     *
     */
    public function addUserWork()
    {
        $vo = (new CourseValidate())->goCheck(['course_id']);
        if ($vo !== true) {
            return $vo;
        }

        $userId = $this->request->userId;
        $data = Request::only(['course_id']);

        $userWork = CourseProgressService::addUserWork($userId, $data['course_id']);

        return $this->returnMsg('操作成功',1,$userWork);
    }

    //视频播放
    public function playVideo(Request $request)
    {
        // 参数验证
        $vo = (new CourseValidate())->goCheck(['course_id']);
        if ($vo !== true) {
            return $vo;
        }

        $courseId = $request->param('course_id');
        $userId = $request->userId;

        // 获取课程信息
        $course = CourseModel::where([
            'id' => $courseId,
            'status' => 3,
            'is_sell' => 1,
            'is_del' => 0
        ])->find();

        if (!$course) {
            return $this->returnMsg('课程不存在');
        }

        // 验证购买状态（1表示视频类型）
        if ($course['price'] > 0 && !UtilService::checkPurchase($userId, $courseId, 1)) {
            return $this->returnMsg('课程未购买', 202);
        }

        // 更新点击量
        CourseModel::where('id', $courseId)->inc('tvclick')->update();

        return $this->returnMsg('操作成功', 1);
    }
}