<?php

namespace app\api\controller\study;

use app\api\validate\StudyInformationValidate;
use app\BaseController;
use app\model\Project as ProjectModel;
use app\model\StudyCategory;
use app\model\StudyInformation;
use think\Request;

class Study extends BaseController
{
    public function getStudyList(Request $request)
    {
        $vo = (new StudyInformationValidate())->goCheck(['category_id']);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->param();

        $page = $request->param('page/d', 1);
        $pageSize = $request->param('pageSize/d', 10);

        $list = (new StudyInformation())->studyList($data['category_id'],$page,$pageSize);

        return $this->returnMsg('success',1,$list);
    }

    public function getStudyDetail(Request $request)
    {
        $vo = (new StudyInformationValidate())->goCheck(['study_information_id']);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->param();

        $data = (new StudyInformation())->studyDetail($data['study_information_id']);

        return $this->returnMsg('success',1,$data);

    }

    public function getStudyCategoryList(Request $request)
    {

        $vo = (new StudyInformationValidate())->goCheck(['pid']);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->param();

        $list = (new StudyCategory())->getStudyCategoryList($data['pid']);

        return $this->returnMsg('success',1,$list);
    }
}