<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\model;

use app\api\service\UserService;
use app\api\service\UtilService;
use app\model\system\SystemUploadFile;
use think\facade\Db;
use think\Model;

/**
 * 模型公用类
 */
class Course extends Model
{

    /**获取推荐课程列表
     */
    public  function getRecommendList($category_id,$page,$pageSize)
    {
        $query = self::where([
            'status' => 3,
            'is_sell' => 1,
            'is_del' => 0,
            'is_tj'=>1
        ]);

        if (!empty($category_id)) {
            $query->where('cate_id', $category_id);
        }

        $list =  $query->order('click,tvclick,createtime', 'desc')
            ->field('id,thumb,title,description,tag_ids,teacher_id')
            ->with(['thumb','getTeacher'=>['thumb']])
            ->paginate([
                'page' => $page,
                'list_rows' => $pageSize
            ]);
        if ($list->isEmpty()) {
            return $list;
        }

        $list = UtilService::listWithTags($list,CourseTag::class,'tag_ids');

        return $list;
    }

    /**获取热门课程列表
     */
    public function getHostList($category_id,$page,$pageSize)
    {
        $query = self::where([
            'status' => 3,
            'is_sell' => 1,
            'is_del' => 0,
            'is_hot' => 1
        ]);

        if (!empty($category_id)) {
            $query->where('cate_id', $category_id);
        }

        $list =  $query->order('click,tvclick,createtime', 'desc')
            ->field('id,thumb,title,description,tag_ids,teacher_id,description,content')
            ->with(['thumb','getTeacher'=>['thumb']])
            ->paginate([
                'page' => $page,
                'list_rows' => $pageSize
            ]);
        if ($list->isEmpty()) {
            return $list;
        }

        $list = UtilService::listWithTags($list,CourseTag::class,'tag_ids');

        return $list;
    }

    /**获取分类下的课程列表
     *
     */
    public function getCourseList($category_id, $page, $pageSize, $searchKeyWords = null)
    {
        $where = ['status' => 3, 'is_sell' => 1, 'is_del' => 0];
        if ($category_id) {
            $where['cate_id'] = $category_id;
        }

        $query = self::where($where);

        if ($searchKeyWords) {
            $query->where('title', 'like', '%' . $searchKeyWords . '%');
        }

        return $query->field('id,thumb,title,createtime,description,price,content')
            ->with(['thumb'])
            ->paginate([
                'page' => $page,
                'list_rows' => $pageSize
            ]);
    }

    //获取课程详情
    public function getCourseDetail($course_id = 0,$userId=0)
    {
        $where = ['status'=>3,'is_sell'=>1,'is_del'=>0];
        if ($course_id)
        {
            $where['id'] = $course_id;
        }

        $detail = self::where($where)
            ->with(['getTeacher'=>['thumb'],'thumb','detailThumb'])
            ->field('id,thumb,title,createtime,description,price,content,teacher_id,tvclick,click,detailthumb')
            ->find();
        if (!$detail)
        {
            return $detail;
        }

        $detail['is_learned'] = 0; //是否学习
        $detail['is_buy'] = 0;//是否购买


        if ($userId)
        {
            $detail['is_learned'] = CourseProgress::where(['course_id'=>$detail['id'],'user_id'=>$userId])->count();

            if($detail['price']<0)
            {
                $detail['is_buy'] = 1;
            }else{
                $detail['is_buy'] = UtilService::checkPurchase($userId,$course_id,1); //是否购买
            }
        }




        return $detail;
    }

    //关联教师
    public function getTeacher()
    {
        return $this->hasOne(CourseTeacher::class, 'id', 'teacher_id')
            ->field('id,nickname,description,thumb_id');
    }

    //关联章节
    public function getSections()
    {
        return $this->hasMany(CourseClassCategory::class, 'course_id','id')
            ->where('is_del',0)
            ->order('sort','desc')
            ->field('id,title,course_id');
    }

    //关联课时
    public function getCourseClass()
    {
        return $this->hasMany(\app\model\CourseClass::class, 'course_id','id')
            ->where('is_del',0)
            ->order('sort','desc');
    }

    //封面图
    public function thumb()
    {
        return $this->hasOne(SystemUploadFile::class, 'fileid', 'thumb')
            ->where('isdel',0)
            ->field('fileid,filename,filesize,fileurl,filetype');
    }

    //详情图
    public function detailThumb()
    {
        return $this->hasOne(SystemUploadFile::class, 'fileid', 'detailthumb')
            ->where('isdel',0)
            ->field('fileid,filename,filesize,fileurl,filetype');
    }


}