<?php

namespace app\api\controller\manage;

use app\api\middleware\Auth;
use app\api\service\UtilService;
use app\api\validate\ShCourseWorkValidate;
use app\BaseController;
use app\model\CertTag;
use app\model\ShCourse;
use app\model\ShCourseWork as ShCourseWorkModel;
use app\Request;

class ShCourseWork extends BaseController
{

    protected $middleware = [
        Auth::class,
    ];

    //添加作业
    public function createShCourseWork(Request $request)
    {
        $vo = (new ShCourseWorkValidate())->goCheck(['course_id', 'title', 'content']);
        if ($vo !== true) {
            return $vo;
        }
        $parm = $request->param();
        $parm['createtime'] = time();
        $parm['sn'] = UtilService::generateCompactOrderNo($request->userId, 'Z');
        $parm['user_id'] = $request->userId;
        $result = ShCourseWorkModel::create($parm);
        ShCourse::where('id', $parm['course_id'])->update(['status' => 0]); //待提交
        return $this->returnMsg('操作成功', 1, $result);
    }

    //作业列表
    public function getShCourseWorkList(Request $request)
    {
        $parm = $request->param();
        $map = [];
        $where = ['is_del' => 0, 'user_id' => $request->userId];
        if (isset($parm['searchKeyWords']) && $parm['searchKeyWords']) {
            $map[] = ['title', 'like', '%' . $parm['searchKeyWords'] . '%'];
        }
        if(isset($parm['course_id']) && $parm['course_id']){
            $map[] = ['course_id', '=', $parm['course_id']];
        }

        $page = $request->param('page', 1);
        $pageSize = $request->param('pageSize', 10);
        $list = ShCourseWorkModel::where($where)->where($map)
            ->order('createtime desc')
            ->append(['course_title'])
            ->paginate([
                'page' => $page,
                'list_rows' => $pageSize
            ]);
        return $this->returnMsg('success', 1, $list);
    }

    //修改作业
    public function editShCourseWork(Request $request)
    {
        $vo = (new ShCourseWorkValidate())->goCheck(['course_id', 'title', 'content','work_id']);
        if ($vo !== true) {
            return $vo;
        }
        $parm = $request->param();
        $udpatedata = $parm;
        unset($udpatedata['work_id']);
        $udpatedata['updatetime'] = time();
        $result = ShCourseWorkModel::where(['user_id' => $request->userId, 'id' => $parm['work_id']])->update($udpatedata);
        ShCourse::where('id', $parm['course_id'])->update(['status' => 0]); //待提交
        return $this->returnMsg('操作成功', 1, $result);

    }

    //作业详情
    public function detailShCourseWork(Request $request){

        $vo = (new ShCourseWorkValidate())->goCheck(['work_id']);
        if ($vo !== true) {
            return $vo;
        }
        $parm = $request->param();
        $info = ShCourseWorkModel::find($parm['work_id'])->append(['filelist']);
        return $this->returnMsg('操作成功', 1, $info);
    }

    //删除作业
    public function deleteShCourseWork(Request $request)
    {

        $vo = (new ShCourseWorkValidate())->goCheck(['work_id']);
        if ($vo !== true) {
            return $vo;
        }
        $parm = $request->param();
        $where = ['id' => $parm['work_id'], 'user_id' => $request->userId];
        $result = ShCourseWorkModel::where($where)->update(['is_del' => 1]);
        $course_id = ShCourseWorkModel::where(['id' => $parm['work_id']])->value('course_id');
        event('Course', ['course_id' => $course_id, 'tasktype' => 'course', 'action' => 'shcourseupdate']); //同步数据
        return $this->returnMsg('操作成功', 1, $result);
    }

}