<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\model;

use think\facade\Db;
use think\Model;
use tool\Tree;

/**
 * 模型公用类
 */
class CourseCategory extends Model
{


    public function catetree($cate_id = 0)
    {
        $map[] = ['is_del', '=', 0];
        $category = $this->where($map)->order('sort desc')->select()->toArray();

        $tree = new Tree();
        $tree->icon = ['&nbsp;&nbsp;│ ', '&nbsp;&nbsp;├─ ', '&nbsp;&nbsp;└─ '];
        $tree->nbsp = '&nbsp;&nbsp;';
        $str = "<option value=@id @selected @disabled>@spacer @title</option>";
        $tree->init($category);
        $categorydata = $tree->getTree(0, $str, $cate_id);
        return $categorydata;
    }

    public function getThumbpathAttr($value, $data)
    {
        return get_upload_file($data['thumb']);
    }

    public function children()
    {
        return $this->hasMany(CourseCategory::class, 'pid');
    }

    /**获取课程分类列表
     * @return CourseCategory[]|array|\think\Collection
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function getCourseCategoryList($pid = 0)
    {
        $limit = 100;
        if ($pid == 0) {
            $limit = 10;
        }
        $where[] = ['is_del', '=', 0];
        return $this->with(['children' => function ($query) use ($where) {
            $query->where($where);
            $query->order('sort', 'desc');
        }])
            ->where('pid', $pid)
            ->where($where)
            ->limit($limit)
            ->order('sort', 'desc')
            ->select();

    }


}