<?php

namespace app\admin\controller\users;
use app\admin\controller\AdminBase;
use app\model\project\UserSmrz;
use think\App;

class Smrz extends AdminBase
{
    protected $smrz;

    public function __construct(App $app)
    {
        parent::__construct($app);
        $this->smrz = new UserSmrz();

    }
    //列表
    public function index(string $do = '')
    {
        $limit = 10;
        if ($do == 'json') {

            $post = input();
            $post['limit'] = isset($post['limit']) ? $post['limit'] : $limit;
            $hasmap[] = ['is_del', '=', 0];
            $map[] = ['user_smrz.is_del', '=', 0];
            if (isset($post['kw']) && !empty($post['kw'])) {
                $hasmap[] = ['username|mobile', 'like', '%' . $post['kw'] . '%'];
            }

            if (isset($post['status']) && $post['status'] > -1) {
                $map[] = ['user_smrz.status', '=', $post['status']];
            }

            $list = $this->smrz->hasWhere('getuserdata',$hasmap)->where($map)->with(['getuserdata'])->append(['status_text','idcard_qurl','idcard_hurl'])->order('id desc')->paginate($post['limit']);
            return $this->returnMsg($list);
        }

        $this->assign('limit', $limit);
        $this->assign('get', input());
        return $this->fetch('', '', false);
    }

    //快速编辑
    public function editup()
    {
        $post = input();
        $result = $this->smrz->update([$post['af'] => $post['av']], [['id', '=', $post['id']]]);
        if ($result) {
            return $this->returnMsg('修改成功', 1);
        } else {
            return $this->returnMsg('修改失败');
        }
    }

    //详情
    public function detail()
    {
        $post = input();
        $info = $this->smrz->with(['smrzQualification','teacherQualification','agreement','moreFile'])->where('id', $post['id'])->find();

        $this->assign('info', $info);

        return $this->fetch('', '', false);
    }


    public function del()
    {
        $post = input();
        $ids = is_array($post['id']) ? implode(',', $post['id']) : $post['id'];
        if ($this->smrz->where("id IN(" . $ids . ")")->update(['is_del' => 1])) {
            return $this->returnMsg("删除成功", 1);
        } else {
            return $this->returnMsg("删除失败");
        }
    }

    //审核资料
    public function shenhesmrz()
    {
        $post = input();
        $errordesc = '';
        $shstatus = 2;
        if ($post['shstatus'] == 2) {
            if (empty($post['errordesc'])) {
                return $this->returnMsg("请输入失败原因");
            }
            $errordesc = $post['errordesc'];
            $shstatus = 1;
        }

        $updatedata['status'] = $shstatus;

        $updatedata['status_desc'] = $errordesc;

        $result = $this->smrz->where('id', $post['id'])->update($updatedata);
        if ($result) {

            return $this->returnMsg("操作成功", 1);
        } else {
            return $this->returnMsg("操作失败");
        }

    }


}