<?php

namespace app\admin\controller\users;

use app\admin\controller\AdminBase;
use app\model\UserExpLog as UserExpLogModel;
use think\App;

class UserExpLog extends AdminBase
{
    protected $userexplog;

    public function __construct(App $app)
    {
        parent::__construct($app);
        $this->userexplog = new UserExpLogModel();

    }

    //列表
    public function index(string $do = '')
    {
        $limit = 10;
        if ($do == 'json') {

            $post = input();
            $post['limit'] = isset($post['limit']) ? $post['limit'] : $limit;
            $hasmap = [];
            if (isset($post['kw']) && !empty($post['kw'])) {
                $hasmap[] = ['username|mobile', 'like', '%' . $post['kw'] . '%'];
            }

            $list = $this->userexplog->hasWhere('getuserdata', $hasmap)->with(['getuserdata', 'getruledata'])->order('id desc')->paginate($post['limit']);
            return $this->returnMsg($list);
        }

        $this->assign('limit', $limit);
        $this->assign('get', input());
        return $this->fetch('', '', false);
    }



    public function del()
    {
        $post = input();
        $ids = is_array($post['id']) ? implode(',', $post['id']) : $post['id'];
        if ($this->userexplog->where("id IN(" . $ids . ")")->update(['is_del' => 1])) {
            return $this->returnMsg("删除成功", 1);
        } else {
            return $this->returnMsg("删除失败");
        }
    }



}