<?php

namespace app\api\service;

use think\facade\Db;
use think\facade\Log;

class ExperienceService
{
    /**
     * 统一处理经验值增加（供中间件和支付逻辑复用）
     */
    public static function addExperience($userId, $rule, $extraData = [])
    {
        // 1. 检查今日是否已达到上限
        $today = strtotime(date('Y-m-d'));
        $expToday = Db::name('user_exp_log')
            ->where('user_id', $userId)
            ->where('rule_id', $rule['id'])
            ->where('create_time', '>=', $today)
            ->sum('exp');

        if ($rule['daily_limit'] != 0 && $expToday >= $rule['daily_limit']) {
            return;
        }

        // 2. 检查是否在间隔时间内（interval_limit > 0 时才检查）
        if ($rule['interval_limit'] > 0) {
            $lastRecord = Db::name('user_exp_log')
                ->where('user_id', $userId)
                ->where('rule_id', $rule['id'])
                ->order('create_time', 'desc')
                ->find();

            if ($lastRecord && (time() - $lastRecord['create_time']) < $rule['interval_limit']) {
                return;
            }
        }
        $extraData = array_merge($extraData, ['action'=>$rule['action']]);
        Db::startTrans();
        try {
            // 增加用户经验
            Db::name('user')
                ->where('id', $userId)
                ->inc('experience', $rule['exp'])
                ->update();

            // 记录日志
            Db::name('user_exp_log')->insert([
                'user_id' => $userId,
                'rule_id' => $rule['id'],
                'exp' => $rule['exp'],
                'create_time' => time(),
                'ip' => request()->ip(),
                'extra_info'=>json_encode($extraData)
            ]);

            Db::commit();
        } catch (\Exception $e) {
            Db::rollback();
            Log::error("经验添加失败：{$userId}-{$rule['id']}, msg: {$e->getMessage()}");
        }

    }

    /**
     * 支付成功后增加经验
     */
    public static function addPaymentExperience($userId, $payment,$action)
    {
        // 获取支付经验规则
        $rule = Db::name('user_exp_rule')
            ->where('action', $action)
            ->where('is_open', 1)
            ->find();

        if (!$rule) return;

        self::addExperience($userId, $rule, [
            'order_id' => $payment['order_id'] ?? 0,
            'order_type' => $payment['order_type'] ?? null,
            'fj_payment_id'=>$payment['fj_payment_id'] ?? 0
        ]);
    }

}