<?php

namespace app\api\controller;

use OSS\OssClient;

class Test
{
    public function concurrentUpload($object, $filePath) {
        $ossClient = new OssClient(/* 配置 */);
        $uploadId = $ossClient->initiateMultipartUpload(config('oss.bucket'), $object);

        $partSize = 10 * 1024 * 1024;
        $fileSize = filesize($filePath);
        $partNum = ceil($fileSize / $partSize);

        $parts = [];
        $promises = [];

        // 使用Guzzle或其他HTTP客户端并发请求
        $client = new \GuzzleHttp\Client();

        for ($i = 1; $i <= $partNum; $i++) {
            $from = ($i - 1) * $partSize;
            $to = min($i * $partSize, $fileSize);

            $promises[] = $client->postAsync('您的上传处理接口', [
                'multipart' => [
                    [
                        'name' => 'part_index',
                        'contents' => $i
                    ],
                    [
                        'name' => 'file',
                        'contents' => fopen($filePath, 'r'),
                        'headers' => [
                            'Content-Range' => 'bytes '.$from.'-'.$to.'/'.$fileSize
                        ]
                    ]
                ]
            ])->then(function($response) use (&$parts, $i) {
                $parts[$i] = [
                    'PartNumber' => $i,
                    'ETag' => $response->getHeader('ETag')[0]
                ];
            });
        }

        // 等待所有分片上传完成
        \GuzzleHttp\Promise\Utils::all($promises)->wait();

        // 按分片顺序排序
        ksort($parts);

        // 完成上传
        $ossClient->completeMultipartUpload(config('oss.bucket'), $object, $uploadId, $parts);
    }
}