<?php

namespace app\api\middleware;
use app\api\service\TokenService;
use app\BaseController;
use think\facade\Request;
use think\Response;

class Auth extends BaseController
{
    public function handle($request, \Closure $next)
    {
        // 在这里编写你的验证逻辑
        $token = $request->header('token');

        if (!$this->checkToken($request,$token)) {
            return $this->returnMsg('Unauthorized',201);
        }
        $request->token = $token;

        return $next($request);
    }

    protected function checkToken($request,$token)
    {

        if (!$token)
        {
            return false;
        }

        $user = TokenService::verifyToken($token);
        if ($user===false)
        {
            return false;
        }
        if ($user['user']['status']!=1)
        {
            return false;
        }

        $request->userId = $user['user_id'];

        return true;
    }
}