<?php

namespace app\api\controller;

use app\api\middleware\Auth;
use app\api\service\TokenService;
use app\api\service\UserService;
use app\api\validate\BusinessValidate;
use app\api\validate\SchoolValidate;
use app\BaseController;
use app\model\project\School;
use app\model\project\School as schoolModel;
use app\model\project\Business as businessModel;
use app\model\project\User as userModel;
use app\Request;
use think\facade\Cache;

/**
 * 入驻
 */
class Settled extends BaseController
{

    protected $middleware = [
        Auth::class,
    ];

    /**高校入驻
     *
     */
    public function school(Request $request)
    {
        $vo = (new SchoolValidate())->goCheck();
        if ($vo !== true) {
            return $vo;
        }

        $data = $request->param();
        $token = $request->header('token');

        $user  = UserService::getUserInfo($token);
        if (!$user)
        {
            return $this->returnMsg('token无效');
        }

//        if (schoolModel::where('user_id', $user['id'])->count())
//        {
//            return $this->returnMsg('请勿重复提交',0);
//        }


        $data['user_id'] = $user['id'];
        $affectedRows = schoolModel::where('user_id', $user['id'])->count();

        if ($affectedRows === 0) {
            schoolModel::create($data);
        }else{
            schoolModel::where('user_id', $user['id'])->update($data);
        }


        userModel::where('id',$user['id'])->update(['role'=>3]);

        return $this->returnMsg('操作成功',1);
    }


    /**企业
     *
     */
    public function business(Request $request)
    {
        $vo = (new BusinessValidate())->goCheck();
        if ($vo !== true) {
            return $vo;
        }


        $data = $request->param();
        $token = $request->header('token');

        $user  = UserService::getUserInfo($token);
        if (!$user)
        {
            return $this->returnMsg('token无效',0);
        }

//        if (businessModel::where('user_id', $user['id'])->count())
//        {
//            return $this->returnMsg('请勿重复提交',0);
//        }


        $data['user_id'] = $user['id'];

        $affectedRows = businessModel::where('user_id', $user['id'])->count();

        if ($affectedRows === 0) {
            businessModel::create($data);
        }else{
            businessModel::where('user_id', $user['id'])->update($data);
        }


        userModel::where('id',$user['id'])->update(['role'=>2]);

        return $this->returnMsg('操作成功',1);
    }

    public function getSchoolData(Request $request)
    {
        $vo = (new BusinessValidate())->goCheck(['token']);
        if ($vo !== true) {
            return $vo;
        }

        $token = $request->header('token');

        $user  = UserService::getUserInfo($token);
        if (!$user)
        {
            return $this->returnMsg('token无效',0);
        }

        $data = schoolModel::where(['user_id'=>$user['id']])
            ->append(['school_qualification_list','teacher_qualification_list','agreement_list','more_file_list'])
//            ->with(['schoolQualification','teacherQualification','agreement','moreFile'])
            ->find();

        return $this->returnMsg('操作成功',1,$data);
    }


    public function getBusinessData(Request $request)
    {
        $vo = (new BusinessValidate())->goCheck(['token']);
        if ($vo !== true) {
            return $vo;
        }

        $token = $request->header('token');

        $user  = UserService::getUserInfo($token);
        if (!$user)
        {
            return $this->returnMsg('token无效',0);
        }

        $data = businessModel::where(['user_id'=>$user['id']])
            ->append(['business_qualification_list','business_industry_list','business_project_list','business_more_list'])
            ->with(['businessLogo'])
            ->find();

        return $this->returnMsg('操作成功',1,$data);
    }
}